/*!
******************************************************************************

	@file	xchg.cpp

	Copyright (C) 2008-2009 Vsun86 Development Project. All rights reserved.

******************************************************************************
*/

#include "vsun86.h"
#include "pfemu.h"
#include "pfemu/vcpu.h"
#include "pfemu/softemu.h"

bool vcpu_emulate_xchg( VCPU *cpu, u8 *mem, u32 op_info )
{
	MODRM_INFO modrm;
	if ( !vcpu_analyze_modrm( cpu, mem, op_info, &modrm ) )
		return false;

	const u8 ip_off = OP_BYTES( op_info ) + modrm.bytes;


	VCPU_MMIO_PROCS *mmio;
	u32 addr;

	switch ( OP_CODE(op_info) )
	{
	case 0x86:
		{	// XCHG r/m8, r8
			u8 tmp;
			if ( modrm.rm_index == MODRM_RM_MEM ) {
				addr = modrm.rm_seg->base + modrm.rm_off;
				mmio = vcpu_get_mmio( cpu, addr >> 12 );
				if ( mmio->read8 )
					tmp = mmio->read8( addr );
				else
					tmp = mem[addr];
				if ( mmio->write8 )
					mmio->write8( addr, *(u8 *)modrm.reg );
				else
//					mem[addr] = *(u8 *)modrm.reg;
					return false;
			}
			else {
//				tmp = *(u8 *)modrm.rm_reg;
//				*(u8 *)modrm.rm_reg = *(u8 *)modrm.reg;
				return false;
			}
			*(u8 *)modrm.reg = tmp;
		}
		break;

	case 0x87:
		if ( op_info & OP_PREFIX_CODE32 )
		{	// XCHG r/m32, r32
			u32 tmp;
			if ( modrm.rm_index == MODRM_RM_MEM ) {
				addr = modrm.rm_seg->base + modrm.rm_off;
				mmio = vcpu_get_mmio( cpu, addr >> 12 );
				if ( mmio->read32 )
					tmp = mmio->read32( addr );
				else
					tmp = *(u32 *)&mem[addr];
				if ( mmio->write32 )
					mmio->write32( addr, *(u32 *)modrm.reg );
				else
//					*(u32 *)&mem[addr] = *(u32 *)modrm.reg;
					return false;
			}
			else {
//				tmp = *(u32 *)modrm.rm_reg;
//				*(u32 *)modrm.rm_reg = *(u32 *)modrm.reg;
				return false;
			}
			*(u32 *)modrm.reg = tmp;
		}
		else
		{	// XCHG r/m16, r16
			u16 tmp;
			if ( modrm.rm_index == MODRM_RM_MEM ) {
				addr = modrm.rm_seg->base + modrm.rm_off;
				mmio = vcpu_get_mmio( cpu, addr >> 12 );
				if ( mmio->read16 )
					tmp = mmio->read16( addr );
				else
					tmp = *(u16 *)&mem[addr];
				if ( mmio->write16 )
					mmio->write16( addr, *(u16 *)modrm.reg );
				else
//					*(u16 *)&mem[addr] = *(u16 *)modrm.reg;
					return false;
			}
			else {
//				tmp = *(u16 *)modrm.rm_reg;
//				*(u16 *)modrm.rm_reg = *(u16 *)modrm.reg;
				return false;
			}
			*(u16 *)modrm.reg = tmp;
		}
		break;

	default:
		return false;
	}

	_EIP(cpu) += ip_off;
	return true;
}
