/*!
******************************************************************************

	@file	stos.cpp

	Copyright (C) 2008-2009 Vsun86 Development Project. All rights reserved.

******************************************************************************
*/

#include "vsun86.h"
#include "cpu.h"
#include "pfemu.h"
#include "pfemu/vcpu.h"
#include "pfemu/softemu.h"

bool vcpu_emulate_stos( VCPU *cpu, u8 *mem, u32 op_info )
{
	(void)mem;

	SVM_VMCB_SEG *seg;
	seg = vcpu_get_seg( cpu, VCPU_SEG_INDEX_ES );
	if ( seg == NULL )
		return false;

	char inc_val;
	if ( _EFLAGS(cpu) & F_DF )
		inc_val = -1;
	else
		inc_val = +1;

	VCPU_MMIO_PROCS *mmio;

	if ( op_info & OP_PREFIX_REP )
	{	// REP STOS
		if ( op_info & OP_PREFIX_ADDR32 )
			mmio = vcpu_get_mmio( cpu, (seg->base + _EDI(cpu)) >> 12 );
		else
			mmio = vcpu_get_mmio( cpu, (seg->base + _DI(cpu)) >> 12 );

		switch ( OP_CODE( op_info ) )
		{
		case 0xAA:
			{	// REP STOSB
				const u8 al = _AL(cpu);
				if ( op_info & OP_PREFIX_ADDR32 ) {
					while ( _ECX(cpu) > 0 ) {
						const u32 addr = seg->base + _EDI(cpu);
						if ( (addr & 0xFFF) == 0x000 )
							mmio = vcpu_get_mmio( cpu, addr >> 12 );
						if ( mmio->write8 )
							mmio->write8( addr, al );
						else
//							mem[addr] = al;
							return false;
						_EDI(cpu) += inc_val;
						_ECX(cpu)--;
					}
				}
				else {
					while ( _CX(cpu) > 0 ) {
						const u32 addr = seg->base + _DI(cpu);
						if ( (addr & 0xFFF) == 0x000 )
							mmio = vcpu_get_mmio( cpu, addr >> 12 );
						if ( mmio->write8 )
							mmio->write8( addr, al );
						else
//							mem[addr] = al;
							return false;
						_DI(cpu) += inc_val;
						_CX(cpu)--;
					}
				}
			}
			break;

		case 0xAB:
			if ( op_info & OP_PREFIX_CODE32 )
			{	// REP STOSD
				inc_val *= 4;
				const u32 eax = _EAX(cpu);
				if ( op_info & OP_PREFIX_ADDR32 ) {
					while ( _ECX(cpu) > 0 ) {
						const u32 addr = seg->base + _EDI(cpu);
						if ( (addr & 0xFFF) == 0x000 )
							mmio = vcpu_get_mmio( cpu, addr >> 12 );
						if ( mmio->write32 )
							mmio->write32( addr, eax );
						else
//							*(u32 *)&mem[addr] = eax;
							return false;
						_EDI(cpu) += inc_val;
						_ECX(cpu)--;
					}
				}
				else {
					while ( _CX(cpu) > 0 ) {
						const u32 addr = seg->base + _DI(cpu);
						if ( (addr & 0xFFF) == 0x000 )
							mmio = vcpu_get_mmio( cpu, addr >> 12 );
						if ( mmio->write32 )
							mmio->write32( addr, eax );
						else
//							*(u32 *)&mem[addr] = eax;
							return false;
						_DI(cpu) += inc_val;
						_CX(cpu)--;
					}
				}
			}
			else
			{	// REP STOSW
				inc_val *= 2;
				const u16 ax = _AX(cpu);
				if ( op_info & OP_PREFIX_ADDR32 ) {
					while ( _ECX(cpu) > 0 ) {
						const u32 addr = seg->base + _EDI(cpu);
						if ( (addr & 0xFFF) == 0x000 )
							mmio = vcpu_get_mmio( cpu, addr >> 12 );
						if ( mmio->write16 )
							mmio->write16( addr, ax );
						else
//							*(u16 *)&mem[addr] = ax;
							return false;
						_EDI(cpu) += inc_val;
						_ECX(cpu)--;
					}
				}
				else {
					while ( _CX(cpu) > 0 ) {
						const u32 addr = seg->base + _DI(cpu);
						if ( (addr & 0xFFF) == 0x000 )
							mmio = vcpu_get_mmio( cpu, addr >> 12 );
						if ( mmio->write16 )
							mmio->write16( addr, ax );
						else
//							*(u16 *)&mem[addr] = ax;
							return false;
						_DI(cpu) += inc_val;
						_CX(cpu)--;
					}
				}
			}
			break;

		default:
			return false;
		}
	}
	else
	{	// STOS
		u32 addr;
		if ( op_info & OP_PREFIX_ADDR32 )
			addr = seg->base + _EDI(cpu);
		else
			addr = seg->base + _DI(cpu);
		mmio = vcpu_get_mmio( cpu, addr >> 12 );

		switch ( OP_CODE( op_info ) )
		{
		case 0xAA:
			{	// STOSB
				if ( mmio->write8 )
					mmio->write8( addr, _AL(cpu) );
				else
//					mem[addr] = _AL(cpu);
					return false;
			}
			break;

		case 0xAB:
			if ( op_info & OP_PREFIX_CODE32 )
			{	// STOSD
				inc_val *= 4;
				if ( mmio->write32 )
					mmio->write32( addr, _EAX(cpu) );
				else
//					*(u32 *)&mem[addr] = _EAX(cpu);
					return false;
			}
			else
			{	// STOSW
				inc_val *= 2;
				if ( mmio->write16 )
					mmio->write16( addr, _AX(cpu) );
				else
//					*(u16 *)&mem[addr] = _AX(cpu);
					return false;
			}
			break;

		default:
			return false;
		}

		if ( op_info & OP_PREFIX_ADDR32 )
			_EDI(cpu) += inc_val;
		else
			_DI(cpu) += inc_val;
	}

	_EIP(cpu) += OP_BYTES( op_info );
	return true;
}
