/*!
******************************************************************************

	@file	movs.cpp

	Copyright (C) 2008-2009 Vsun86 Development Project. All rights reserved.

******************************************************************************
*/

#include "vsun86.h"
#include "cpu.h"
#include "pfemu.h"
#include "pfemu/vcpu.h"
#include "pfemu/softemu.h"

bool vcpu_emulate_movs( VCPU *cpu, u8 *mem, u32 op_info )
{
	SVM_VMCB_SEG *src_seg, *dst_seg;
	src_seg = vcpu_get_seg( cpu, OP_PREFIX_SEG( op_info ) >> OP_PREFIX_SEG_SHIFT );
	if ( src_seg == NULL )
		return false;
	dst_seg = vcpu_get_seg( cpu, VCPU_SEG_INDEX_ES );
	if ( dst_seg == NULL )
		return false;

	char inc_val;
	if ( _EFLAGS(cpu) & F_DF )
		inc_val = -1;
	else
		inc_val = +1;

	VCPU_MMIO_PROCS *src_mmio, *dst_mmio;

	if ( op_info & OP_PREFIX_REP )
	{	// REP MOVS
		/*
		if ( op_info & OP_PREFIX_ADDR32 ) {
			src_mmio = vcpu_get_mmio( cpu, (src_seg->base + _ESI(cpu)) >> 12 );
			dst_mmio = vcpu_get_mmio( cpu, (dst_seg->base + _EDI(cpu)) >> 12 );
		}
		else {
			src_mmio = vcpu_get_mmio( cpu, (src_seg->base + _SI(cpu)) >> 12 );
			dst_mmio = vcpu_get_mmio( cpu, (dst_seg->base + _DI(cpu)) >> 12 );
		}

		switch ( OP_CODE( op_info ) )
		{
		case 0xA4:
			{	// REP MOVSB
			}
			break;

		case 0xA5:
			if ( op_info & OP_PREFIX_CODE32 )
			{	// REP MOVSD
			}
			else
			{	// REP MOVSW
			}
			break;
		}
		*/
		return false;	// 未実装
	}
	else
	{	// MOVS
		u32 src_addr, dst_addr;
		if ( op_info & OP_PREFIX_ADDR32 ) {
			src_addr = src_seg->base + _ESI(cpu);
			dst_addr = dst_seg->base + _EDI(cpu);
		}
		else {
			src_addr = src_seg->base + _SI(cpu);
			dst_addr = dst_seg->base + _DI(cpu);
		}
		src_mmio = vcpu_get_mmio( cpu, src_addr >> 12 );
		dst_mmio = vcpu_get_mmio( cpu, dst_addr >> 12 );

		switch ( OP_CODE( op_info ) )
		{
		case 0xA4:
			{	// MOVSB
				u8 data;
				if ( src_mmio->read8 == NULL )
					data = mem[src_addr];
				else
					data = src_mmio->read8( src_addr );
				if ( dst_mmio->write8 == NULL )
					mem[dst_addr] = data;
				else
					dst_mmio->write8( dst_addr, data );
			}
			break;

		case 0xA5:
			if ( op_info & OP_PREFIX_CODE32 )
			{	// MOVSD
				u32 data;
				if ( src_mmio->read32 == NULL )
					data = *(u32 *)&mem[src_addr];
				else
					data = src_mmio->read32( src_addr );
				if ( dst_mmio->write32 == NULL )
					*(u32 *)&mem[dst_addr] = data;
				else
					dst_mmio->write32( dst_addr, data );
			}
			else
			{	// MOVSW
				u16 data;
				if ( src_mmio->read16 == NULL )
					data = *(u16 *)&mem[src_addr];
				else
					data = src_mmio->read16( src_addr );
				if ( dst_mmio->write16 == NULL )
					*(u16 *)&mem[dst_addr] = data;
				else
					dst_mmio->write16( dst_addr, data );
			}
			break;

		default:
			return false;
		}

		if ( op_info & OP_PREFIX_ADDR32 ) {
			_ESI(cpu) += inc_val;
			_EDI(cpu) += inc_val;
		}
		else {
			_SI(cpu) += inc_val;
			_DI(cpu) += inc_val;
		}
	}

	_EIP(cpu) += OP_BYTES( op_info );
	return true;
}
