/*!
******************************************************************************

	@file	pfemu.h

	Copyright (C) 2008 Vsun86 Development Project. All rights reserved.

******************************************************************************
*/

#ifndef __PFEMU_H__
#define __PFEMU_H__

typedef u32 VMID;
#define VMID_INVALID	(0xFFFFFFFF)

#define VM_MODULE_SIZE	0x00400000	// 4MB
#define VM_MODULE		(vm_module)
extern u8 vm_module[VM_MODULE_SIZE];

typedef struct {
	VMID	vmid;
	void *	vcpu;
	void *	vmcb;
	void *	page_dir;
	void *	page_tbl;
	void *	mem;
	void *	iopm;
	void *	msrpm;
} VSUN86_VM;

extern bool pfemu_init( void );
//extern void pfemu_task( void * );
extern VSUN86_VM * pfemu_get_vm( void );
extern void * pfemu_get_vcpu( void );
extern bool pfemu_run_vcpu( void * );
extern bool pfemu_set_vcpu_event( void * );
extern bool pfemu_set_vcpu_mmio( u32, u32, void * );

#endif // !__PFEMU_H__
