/*!
******************************************************************************

	@file	mboot.cpp

	Copyright (C) 2008-2009 Vsun86 Development Project. All rights reserved.

******************************************************************************
*/

#include "vsun86.h"
#include "mboot.h"
#include "printf.h"

#include <string.h>

static struct {
	MBOOT_MEMORY_INFO *			mem;
	MBOOT_BOOT_DEVICE_INFO *	boot_device;
	char *						cmdline;
	MBOOT_MODULE_INFO_HEADER *	mods;
	MBOOT_SYMBOL_INFO *			syms;
	MBOOT_ELF_SECTION_INFO *	section;
	MBOOT_MMAP_INFO_HEADER *	mmap;
	MBOOT_DRIVE_INFO_HEADER *	drives;
	void *						config_table;
	char *						loader_name;
	MBOOT_APM_INFO *			apm_table;
} mboot_info;

bool mboot_init( void *mboot_info_ptr )
{
	u8 *p = (u8 *)mboot_info_ptr;
	const u32 flags = *(u32 *)&p[0];
	memset( &mboot_info, 0, sizeof(mboot_info) );

	if ( flags & MBINFO_FLAG_MEMORY )
		mboot_info.mem = (MBOOT_MEMORY_INFO *)&p[4];

	if ( flags & MBINFO_FLAG_BOOT_DEVICE )
		mboot_info.boot_device = (MBOOT_BOOT_DEVICE_INFO *)&p[12];

	if ( flags & MBINFO_FLAG_CMDLINE )
		mboot_info.cmdline = *(char **)&p[16];

	if ( flags & MBINFO_FLAG_MODULES )
		mboot_info.mods = (MBOOT_MODULE_INFO_HEADER *)&p[20];

	if ( flags & MBINFO_FLAG_SYMBOLS )
		mboot_info.syms = (MBOOT_SYMBOL_INFO *)&p[28];
	else if ( flags & MBINFO_FLAG_ELF_SECTION )
		mboot_info.section = (MBOOT_ELF_SECTION_INFO *)&p[28];

	if ( flags & MBINFO_FLAG_MMAP )
		mboot_info.mmap = (MBOOT_MMAP_INFO_HEADER *)&p[44];

	if ( flags & MBINFO_FLAG_DRIVES )
		mboot_info.drives = (MBOOT_DRIVE_INFO_HEADER *)&p[52];

	if ( flags & MBINFO_FLAG_CONFIG )
		mboot_info.config_table = *(void **)&p[60];

	if ( flags & MBINFO_FLAG_LOADER_NAME )
		mboot_info.loader_name = *(char **)&p[64];

	if ( flags & MBINFO_FLAG_APM )
		mboot_info.apm_table = *(MBOOT_APM_INFO **)&p[68];

	vmm_printf( VMM_DEBUG, "mboot: loader_name=\"%s\", cmdline=\"%s\"\n",
				mboot_get_loader_name(), mboot_get_cmdline() );
	

	return true;
}

const MBOOT_MEMORY_INFO * mboot_get_memory_info( void )
{
	return mboot_info.mem;
}

const MBOOT_BOOT_DEVICE_INFO * mboot_get_boot_device( void )
{
	return mboot_info.boot_device;
}

const char * mboot_get_cmdline( void )
{
	return mboot_info.cmdline;
}

const MBOOT_MODULE_INFO_HEADER * mboot_get_module_info_header( void )
{
	return mboot_info.mods;
}

const MBOOT_SYMBOL_INFO * mboot_get_symbol_info( void )
{
	return mboot_info.syms;
}

const MBOOT_ELF_SECTION_INFO * mboot_get_elf_section_header_table( void )
{
	return mboot_info.section;
}

const MBOOT_MMAP_INFO_HEADER * mboot_get_mmap_info_header( void )
{
	return mboot_info.mmap;
}

const MBOOT_DRIVE_INFO_HEADER * mboot_get_drive_info_header( void )
{
	return mboot_info.drives;
}

const void * mboot_get_config_table( void )
{
	return mboot_info.config_table;
}

const char * mboot_get_loader_name( void )
{
	return mboot_info.loader_name;
}

const MBOOT_APM_INFO * mboot_get_apm_table( void )
{
	return mboot_info.apm_table;
}
