/*!
******************************************************************************

	@file	io.h

	Copyright (C) 2008-2009 Vsun86 Development Project. All rights reserved.

******************************************************************************
*/

#ifndef __IO_H__
#define __IO_H__

#include "common.h"

#ifndef _VSUN86_PCSIM
#define inb( port )											\
({															\
	u8 _value;												\
	__ASM__( "inb %w1, %b0" : "=a"(_value) : "Nd"(port) );	\
	_value;													\
})

#define inw( port )											\
({															\
	u16 _value;												\
	__ASM__( "inw %w1, %w0" : "=a"(_value) : "Nd"(port) );	\
	_value;													\
})

#define ind( port )											\
({															\
	u32 _value;												\
	__ASM__( "inl %w1, %0" : "=a"(_value) : "Nd"(port) );	\
	_value;													\
})

#define outb( port, value )									\
({															\
	__ASM__( "outb	%b0, %w1	\n\t"						\
			 "nop				\n\t"						\
			 :: "a"(value), "Nd"(port) );					\
})

#define outw( port, value )									\
({															\
	__ASM__( "outw	%w0, %w1	\n\t"						\
			 "nop				\n\t"						\
			 :: "a"(value), "Nd"(port) );					\
})

#define outd( port, value )									\
({															\
	__ASM__( "outl	%0, %w1		\n\t"						\
			 "nop				\n\t"						\
			 :: "a"(value), "Nd"(port) );					\
})
#endif	//!_VSUN86_PCSIM

#endif	//!__IO_H__
