#include	"compiler.h"
#include	"dosio.h"

OEMCHAR dosio_dir[MAX_PATH];

void dosio_init( void )
{
	fprintf( stderr, "[STUB] dosio_init()\n" );
	ZeroMemory( dosio_dir, sizeof(dosio_dir) );
}

void dosio_term( void )
{
	fprintf( stderr, "[STUB] dosio_term()\n" );
}

FILEH DOSIOCALL file_open( const OEMCHAR *path )
{
//	fprintf( stderr, "file_open( path=\"%s\" )\n", path );

	int fd = Vsun86_OpenFile( path );
	if ( fd == FILE_DESC_INVALID )
		return FILEH_INVALID;

	return fd;
}

FILEH DOSIOCALL file_open_rb( const OEMCHAR *path )
{
//	fprintf( stderr, "file_open_rb( path=\"%s\" )\n", path );

	int fd = Vsun86_OpenFile( path );
	if ( fd == FILE_DESC_INVALID )
		return FILEH_INVALID;

	return fd;
}

FILEH DOSIOCALL file_create( const OEMCHAR *path )
{
	fprintf( stderr, "[STUB] file_create( path=\"%s\" )\n", path );
	return FILEH_INVALID;
}

long DOSIOCALL file_seek( FILEH handle, long pointer, int method )
{
//	fprintf( stderr, "file_seek( handle=%08x, pointer=%d, method=%d )\n",
//			 handle, pointer, method );

	return Vsun86_SetFilePointer( handle, pointer, method );
}

UINT DOSIOCALL file_read( FILEH handle, void *data, UINT length )
{
//	fprintf( stderr, "file_read( handle=%08x, data=%08x, length=%08x )\n",
//			 handle, data, length );

	if ( -1 == Vsun86_ReadFile( handle, data, length ) ) {
		fprintf( stderr, "Vsun86_ReadFile() failed.\n" );
		return 0;
	}

	return length;
}

UINT DOSIOCALL file_write( FILEH handle, const void *data, UINT length )
{
	fprintf( stderr, "[STUB] file_write( handle=%08x, data=%08x, length=%08x )\n",
			 handle, data, length );
	return 0;
}

short DOSIOCALL file_close( FILEH handle )
{
	Vsun86_CloseFile( handle );
//	fprintf( stderr, "file_close( handle=%08x )\n", handle );
	return 0;
}

UINT DOSIOCALL file_getsize( FILEH handle )
{
	size_t size;

	fprintf( stderr, "file_getsize( handle=%08x )\n", handle );

	if ( -1 == Vsun86_GetFileSize( handle, &size ) )
		return 0;

	return size;
}

short DOSIOCALL file_getdatetime( FILEH handle, DOSDATE *dosdate, DOSTIME *dostime )
{
	fprintf( stderr, "[STUB] file_getdatetime( handle=%08x, dosdate=%08x, dostime=%08x )\n",
			 handle, dosdate, dostime );
	return -1;
}

short DOSIOCALL file_delete( const OEMCHAR *path )
{
	fprintf( stderr, "[STUB] file_delete( path=\"%s\" )\n", path );
	return -1;
}

short DOSIOCALL file_attr( const OEMCHAR *path )
{
	fprintf( stderr, "[STUB] file_attr( path=\"%s\" )\n", path );
	return 0;
}

short DOSIOCALL file_dircreate( const OEMCHAR *path )
{
	fprintf( stderr, "[STUB] file_dircreate( path=\"%s\" )\n", path );
	return -1;
}

void DOSIOCALL file_setcd( const OEMCHAR *exepath )
{
	fprintf( stderr, "[STUB] file_setcd( path=\"%s\" )\n", exepath );
	strcpy( dosio_dir, exepath );
}

OEMCHAR * DOSIOCALL file_getcd( const OEMCHAR *path )
{
	static OEMCHAR ret[MAX_PATH];

	fprintf( stderr, "[STUB] file_getcd( path=\"%s\" )\n", path );
	sprintf( ret, "%s%s", dosio_dir, path );
	return (OEMCHAR *)ret;
}

FILEH DOSIOCALL file_open_c( const OEMCHAR *path )
{
	fprintf( stderr, "[STUB] file_open_c( path=\"%s\" )\n", path );
	return FILEH_INVALID;
}

FILEH DOSIOCALL file_open_rb_c( const OEMCHAR *path )
{
	fprintf( stderr, "[STUB] file_open_rb_c( path=\"%s\" )\n", path );
	return FILEH_INVALID;
}

FILEH DOSIOCALL file_create_c( const OEMCHAR *path )
{
	fprintf( stderr, "[STUB] file_create_c( path=\"%s\" )\n", path );
	return FILEH_INVALID;
}

short DOSIOCALL file_delete_c( const OEMCHAR *path )
{
	fprintf( stderr, "[STUB] file_delete_c( path=\"%s\" )\n", path );
	return -1;
}

short DOSIOCALL file_attr_c( const OEMCHAR *path )
{
	fprintf( stderr, "[STUB] file_attr_c( path=\"%s\" )\n", path );
	return 0;
}

FLISTH DOSIOCALL file_list1st( const OEMCHAR *dir, FLINFO *fli )
{
	fprintf( stderr, "[STUB] file_list1st( dir=\"%s\", fli=%08x )\n", dir, fli );
	return FLISTH_INVALID;
}

BRESULT DOSIOCALL file_listnext( FLISTH hdl, FLINFO *fli )
{
	fprintf( stderr, "[STUB] file_listnext( hdl=%08x, fli=%08x )\n", hdl, fli );
	return FAILURE;
}

void DOSIOCALL file_listclose( FLISTH hdl )
{
	fprintf( stderr, "[STUB] file_listclose( hdl=%08x )\n", hdl );
}

OEMCHAR * DOSIOCALL file_getname( const OEMCHAR *path )
{
	int i, off, csize;

	i = 0;
	off = 0;
	while ( 0 != (csize = milstr_charsize( &path[i] )) ) {
		if ( (csize == 1) && (path[i] == '/') )
			off = i + 1;
		i += csize;
	}

	fprintf( stderr, "file_getname( path=\"%s\" ) = \"%s\"\n", path, &path[off] );

	return (OEMCHAR *)&path[off];
}

void DOSIOCALL file_cutname( OEMCHAR *path )
{
	OEMCHAR	*p;

	p = file_getname( path );
	fprintf( stderr, "file_cutname( path=\"%s\" ) = ", path );
	p[0] = '\0';
	fprintf( stderr, "\"%s\"\n", path );
}

OEMCHAR * DOSIOCALL file_getext( const OEMCHAR *path )
{
	const OEMCHAR	*p;
	const OEMCHAR	*q;
	int				csize;

	p = file_getname(path);
	q = NULL;
	while((csize = milstr_charsize(p)) != 0) {
		if ((csize == 1) && (*p == '.')) {
			q = p + 1;
		}
		p += csize;
	}
	if (q == NULL) {
		q = p;
	}

	fprintf( stderr, "file_getext( path=\"%s\" ) = \"%s\"\n", path, q );

	return((OEMCHAR *)q);
}

void DOSIOCALL file_cutext(OEMCHAR *path) {

	OEMCHAR	*p;
	OEMCHAR	*q;
	int		csize;

	fprintf( stderr, "file_cutext( path=\"%s\" )\n", path );

	p = file_getname(path);
	q = NULL;
	while((csize = milstr_charsize(p)) != 0) {
		if ((csize == 1) && (*p == '.')) {
			q = p;
		}
		p += csize;
	}
	if (q) {
		*q = '\0';
	}
}

void DOSIOCALL file_cutseparator(OEMCHAR *path) {

	int		pos;

	fprintf( stderr, "file_cutseparator( path=\"%s\" )\n", path );

	pos = OEMSTRLEN(path) - 1;
	if ((pos > 0) &&							// 2ȏŁ[
		(path[pos] == '\\') &&					// Pc \ Ł[
		(!milstr_kanji2nd(path, pos)) &&		// 2oCgڂȂā[
		((pos != 1) || (path[0] != '\\')) &&	// '\\' ł͂Ȃā[
		((pos != 2) || (path[1] != ':'))) {		// '?:\' ł͂Ȃ
		path[pos] = '\0';
	}
}

void DOSIOCALL file_setseparator(OEMCHAR *path, int maxlen) {

	int		pos;

	fprintf( stderr, "file_setseparator( path=\"%s\", maxlen=%d )\n", path, maxlen );

	pos = OEMSTRLEN(path) - 1;
	if ((pos < 0) ||
		((pos == 1) && (path[1] == ':')) ||
		((path[pos] == '\\') && (!milstr_kanji2nd(path, pos))) ||
		((pos + 2) >= maxlen)) {
		return;
	}
	path[++pos] = '\\';
	path[++pos] = '\0';
}

