
#define INTR_FAST

// #define	I286C_TEST
#if defined(I286C_TEST)
#undef MEMOPTIMIZE
#endif

//#define	I286_STAT		i286core.s.r

//#define	I286_REG		I286_STAT.r
//#define	I286_SEGREG		I286_STAT.r.w.es

#define	I286_AX			CPU_AX
#define	I286_BX			CPU_BX
#define	I286_CX			CPU_CX
#define	I286_DX			CPU_DX
#define	I286_SI			CPU_SI
#define	I286_DI			CPU_DI
#define	I286_BP			CPU_BP
#define	I286_SP			CPU_SP
#define	I286_CS			CPU_CS
#define	I286_DS			CPU_DS
#define	I286_ES			CPU_ES
#define	I286_SS			CPU_SS
#define	I286_IP			CPU_IP

/*
#define	SEG_BASE		CPU_STATSAVE.es_base
#define	ES_BASE			CPU_STATSAVE.es_base
#define	CS_BASE			CPU_STATSAVE.cs_base
#define	SS_BASE			CPU_STATSAVE.ss_base
#define	DS_BASE			CPU_STATSAVE.ds_base
*/
#define	SS_FIX			CPU_CORE.s.ss_fix
#define	DS_FIX			CPU_CORE.s.ds_fix

#define	I286_AL			CPU_AL
#define	I286_BL			CPU_BL
#define	I286_CL			CPU_CL
#define	I286_DL			CPU_DL
#define	I286_AH			CPU_AH
#define	I286_BH			CPU_BH
#define	I286_CH			CPU_CH
#define	I286_DH			CPU_DH

#define	I286_FLAG		_rFLAGS(CPU_REGS).w
#define	I286_FLAGL		_rFLAGS(CPU_REGS).bl
#define	I286_FLAGH		_rFLAGS(CPU_REGS).bh
#define	I286_TRAP		CPU_CORE.s.trap
#define	I286_OV			CPU_CORE.s.ovflag

#define	I286_GDTR		CPU_CORE.s.i286.GDTR
#define	I286_IDTR		CPU_CORE.s.i286.IDTR
#define	I286_LDTR		CPU_CORE.s.i286.LDTR
#define	I286_LDTRC		CPU_CORE.s.i286.LDTRC
#define	I286_TR			CPU_CORE.s.i286.TR
#define	I286_TRC		CPU_CORE.s.i286.TRC
#define	I286_MSW		CPU_MSW

#define	I286_REMCLOCK	CPU_REMCLOCK
#define	I286_BASECLOCK	CPU_BASECLOCK
#define	I286_CLOCK		CPU_CLOCK
#define	I286_ADRSMASK	CPU_ADRSMASK

#define	I286_PREFIX		CPU_CORE.s.prefix

#define	I286_INPADRS	CPU_EXT.inport


#define I286FN	static void
#define I286EXT	void

typedef void (*I286OP)(void);

extern void CPUCALL i286c_intnum(UINT vect, REG16 IP);
extern UINT32 i286c_selector(UINT sel);

#if !defined(MEMOPTIMIZE) || (MEMOPTIMIZE < 2)
extern void i286cea_initialize(void);
#endif

extern const I286OP i286op[];
extern const I286OP i286op_repe[];
extern const I286OP i286op_repne[];

#define	I286_0F	static void CPUCALL
typedef void (CPUCALL * I286OP_0F)(UINT op);

I286EXT i286c_cts(void);


#define	I286_8X	static void CPUCALL
typedef void (CPUCALL * I286OP8XREG8)(UINT8 *p);
typedef void (CPUCALL * I286OP8XEXT8)(UINT32 madr);
typedef void (CPUCALL * I286OP8XREG16)(UINT16 *p, UINT32 src);
typedef void (CPUCALL * I286OP8XEXT16)(UINT32 madr, UINT32 src);

extern const I286OP8XREG8 c_op8xreg8_table[];
extern const I286OP8XEXT8 c_op8xext8_table[];
extern const I286OP8XREG16 c_op8xreg16_table[];
extern const I286OP8XEXT16 c_op8xext16_table[];


#define	I286_SFT static void CPUCALL
typedef void (CPUCALL * I286OPSFTR8)(UINT8 *p);
typedef void (CPUCALL * I286OPSFTE8)(UINT32 madr);
typedef void (CPUCALL * I286OPSFTR16)(UINT16 *p);
typedef void (CPUCALL * I286OPSFTE16)(UINT32 madr);
typedef void (CPUCALL * I286OPSFTR8CL)(UINT8 *p, REG8 cl);
typedef void (CPUCALL * I286OPSFTE8CL)(UINT32 madr, REG8 cl);
typedef void (CPUCALL * I286OPSFTR16CL)(UINT16 *p, REG8 cl);
typedef void (CPUCALL * I286OPSFTE16CL)(UINT32 madr, REG8 cl);

extern const I286OPSFTR8 sft_r8_table[];
extern const I286OPSFTE8 sft_e8_table[];
extern const I286OPSFTR16 sft_r16_table[];
extern const I286OPSFTE16 sft_e16_table[];
extern const I286OPSFTR8CL sft_r8cl_table[];
extern const I286OPSFTE8CL sft_e8cl_table[];
extern const I286OPSFTR16CL sft_r16cl_table[];
extern const I286OPSFTE16CL sft_e16cl_table[];


#define	I286_F6 static void CPUCALL
typedef void (CPUCALL * I286OPF6)(UINT op);

extern const I286OPF6 c_ope0xf6_table[];
extern const I286OPF6 c_ope0xf7_table[];


extern const I286OPF6 c_ope0xfe_table[];
extern const I286OPF6 c_ope0xff_table[];


extern I286EXT i286c_rep_insb(void);
extern I286EXT i286c_rep_insw(void);
extern I286EXT i286c_rep_outsb(void);
extern I286EXT i286c_rep_outsw(void);
extern I286EXT i286c_rep_movsb(void);
extern I286EXT i286c_rep_movsw(void);
extern I286EXT i286c_rep_lodsb(void);
extern I286EXT i286c_rep_lodsw(void);
extern I286EXT i286c_rep_stosb(void);
extern I286EXT i286c_rep_stosw(void);
extern I286EXT i286c_repe_cmpsb(void);
extern I286EXT i286c_repne_cmpsb(void);
extern I286EXT i286c_repe_cmpsw(void);
extern I286EXT i286c_repne_cmpsw(void);
extern I286EXT i286c_repe_scasb(void);
extern I286EXT i286c_repne_scasb(void);
extern I286EXT i286c_repe_scasw(void);
extern I286EXT i286c_repne_scasw(void);


#define i286_memoryread(a)			memp_read8(a)
#define i286_memoryread_w(a)		memp_read16(a)
#define i286_memoryread_d(a)		memp_read32(a)
#define i286_memorywrite(a, v)		memp_write8(a, v)
#define i286_memorywrite_w(a, v)	memp_write16(a, v)
#define i286_memorywrite_d(a, v)	memp_write32(a, v)

