
#include "memory.h"

#if 1 // !defined(CPUDEBUG)
enum {
	I286_MEMREADMAX		= 0xa4000,
	I286_MEMWRITEMAX	= 0xa0000
};
#else									// _CNgANZX͈͂߂
enum {
	I286_MEMREADMAX		= 0x00400,
	I286_MEMWRITEMAX	= 0x00400
};
#endif

enum {
	C_FLAG			= 0x0001,
	P_FLAG			= 0x0004,
	A_FLAG			= 0x0010,
	Z_FLAG			= 0x0040,
	S_FLAG			= 0x0080,
	T_FLAG			= 0x0100,
	I_FLAG			= 0x0200,
	D_FLAG			= 0x0400,
	O_FLAG			= 0x0800
};

enum {
	MSW_PE			= 0x0001,
	MSW_MP			= 0x0002,
	MSW_EM			= 0x0004,
	MSW_TS			= 0x0008
};

enum {
	CPUTYPE_V30		= 0x01
};

#ifndef CPUCALL
#define	CPUCALL
#endif

typedef struct {
	UINT16	limit;
	UINT16	base;
	UINT8	base24;
	UINT8	reserved;
} I286DTR;

typedef struct {
	I286DTR	GDTR;
	UINT16	MSW;
	I286DTR	IDTR;
	UINT16	LDTR;							// ver0.73
	I286DTR	LDTRC;
	UINT16	TR;
	I286DTR	TRC;
} I286REGS;

typedef struct {
	/*
	union {
		I386REG8	b;
		I386REG16	w;
	}		r;
	UINT32	es_base;
	UINT32	cs_base;
	UINT32	ss_base;
	UINT32	ds_base;
	*/
	UINT32	ss_fix;
	UINT32	ds_fix;
	UINT32	adrsmask;						// ver0.72
	UINT16	prefix;
	UINT8	trap;
	UINT8	resetreq;						// ver0.72
	UINT32	ovflag;
	/*
	I286DTR	GDTR;
	UINT16	MSW;
	I286DTR	IDTR;
	UINT16	LDTR;							// ver0.73
	I286DTR	LDTRC;
	UINT16	TR;
	I286DTR	TRC;
	*/
	UINT8	padding[2];

	UINT8	cpu_type;
	UINT8	itfbank;						// ver0.72
	UINT16	ram_d0;
	SINT32	remainclock;
	SINT32	baseclock;
	UINT32	clock;

	I286REGS i286;
} I386STAT;

typedef struct {							// for ver0.73
	UINT8	*ext;
	UINT32	extsize;
	UINT8	*extbase;						// ext - 0x100000
	UINT32	extlimit16mb;					// extsize + 0x100000
	UINT8	*ems[4];
	UINT32	inport;
#if defined(CPUSTRUC_MEMWAIT)
	UINT8	tramwait;
	UINT8	vramwait;
	UINT8	grcgwait;
	UINT8	padding;
#endif
} I386EXT;

typedef struct {
	I386STAT	s;							// STATsavez
	I386EXT		e;
	VCPU *		r;
} I386CORE;


#ifdef __cplusplus
extern "C" {
#endif

extern	UINT8 *		mem;
extern	I386CORE	i386core;
extern	const UINT8	iflags[];

void i386v_initialize(void);
void i386v_deinitialize(void);
void i386v_reset(void);
void i386v_shut(void);
void i386v_setextsize(UINT32 size);
void i386v_setemm(UINT frame, UINT32 addr);

void CPUCALL i386v_interrupt(REG8 vect);

void i386v(void);
void i386v_step(void);

void i386v_a20en(BOOL);

//void v30c(void);
//void v30c_step(void);

#ifdef __cplusplus
}
#endif


// ---- macros

#define CPU_CORE		i386core
#define	CPU_STATSAVE	i386core.s
#define CPU_EXT			i386core.e
#define CPU_REGS		i386core.r

#define	CPU_AX			_AX(CPU_REGS)
#define	CPU_BX			_BX(CPU_REGS)
#define	CPU_CX			_CX(CPU_REGS)
#define	CPU_DX			_DX(CPU_REGS)
#define	CPU_SI			_SI(CPU_REGS)
#define	CPU_DI			_DI(CPU_REGS)
#define	CPU_BP			_BP(CPU_REGS)
#define	CPU_SP			_SP(CPU_REGS)
#define	CPU_CS			_CS(CPU_REGS).selector
#define	CPU_DS			_DS(CPU_REGS).selector
#define	CPU_ES			_ES(CPU_REGS).selector
#define	CPU_SS			_SS(CPU_REGS).selector
#define CPU_FS			_FS(CPU_REGS).selector
#define CPU_GS			_GS(CPU_REGS).selector
#define	CPU_IP			_IP(CPU_REGS)

#define	CPU_EAX			_EAX(CPU_REGS)
#define	CPU_EBX			_EBX(CPU_REGS)
#define	CPU_ECX			_ECX(CPU_REGS)
#define	CPU_EDX			_EDX(CPU_REGS)
#define	CPU_ESI			_ESI(CPU_REGS)
#define	CPU_EDI			_EDI(CPU_REGS)
#define	CPU_EBP			_EBP(CPU_REGS)
#define	CPU_ESP			_ESP(CPU_REGS)
#define CPU_EIP			_EIP(CPU_REGS)
#define CPU_EFLAGS		_EFLAGS(CPU_REGS)

#define	ES_BASE			_ES(CPU_REGS).base
#define	CS_BASE			_CS(CPU_REGS).base
#define	SS_BASE			_SS(CPU_REGS).base
#define	DS_BASE			_DS(CPU_REGS).base
#define FS_BASE			_FS(CPU_REGS).base
#define GS_BASE			_GS(CPU_REGS).base

#define	CPU_AL			_AL(CPU_REGS)
#define	CPU_BL			_BL(CPU_REGS)
#define	CPU_CL			_CL(CPU_REGS)
#define	CPU_DL			_DL(CPU_REGS)
#define	CPU_AH			_AH(CPU_REGS)
#define	CPU_BH			_BH(CPU_REGS)
#define	CPU_CH			_CH(CPU_REGS)
#define	CPU_DH			_DH(CPU_REGS)

#define	CPU_FLAG		_FLAGS(CPU_REGS)
#define	CPU_FLAGL		_rFLAGS(CPU_REGS).bl

#define CPU_CR0			V_CR0(CPU_REGS).d
#define CPU_CR2			V_CR2(CPU_REGS).d
#define CPU_CR3			V_CR3(CPU_REGS).d
#define CPU_CR4			V_CR4(CPU_REGS).d

#define CPU_DR0			_DR0(CPU_REGS).d
#define CPU_DR1			_DR1(CPU_REGS).d
#define CPU_DR2			_DR2(CPU_REGS).d
#define CPU_DR3			_DR3(CPU_REGS).d
#define CPU_DR6			_DR6(CPU_REGS).d
#define CPU_DR7			_DR7(CPU_REGS).d

#define	CPU_REMCLOCK	CPU_CORE.s.remainclock
#define	CPU_BASECLOCK	CPU_CORE.s.baseclock
#define	CPU_CLOCK		CPU_CORE.s.clock
#define	CPU_ADRSMASK	CPU_CORE.s.adrsmask
#define	CPU_MSW			V_CR0(CPU_REGS).w
#define	CPU_RESETREQ	CPU_CORE.s.resetreq
#define	CPU_ITFBANK		CPU_CORE.s.itfbank
#define	CPU_RAM_D000	CPU_CORE.s.ram_d0

#define	CPU_EXTMEM		CPU_EXT.ext
#define	CPU_EXTMEMSIZE	CPU_EXT.extsize
#define	CPU_EXTMEMBASE	CPU_EXT.extbase
#define	CPU_EXTLIMIT16	CPU_EXT.extlimit16mb
#define	CPU_INPADRS		CPU_EXT.inport
#define	CPU_EMSPTR		CPU_EXT.ems

#define	CPU_TYPE		CPU_CORE.s.cpu_type

#if defined(CPUSTRUC_MEMWAIT)
#define	MEMWAIT_TRAM	CPU_EXT.tramwait
#define	MEMWAIT_VRAM	CPU_EXT.vramwait
#define	MEMWAIT_GRCG	CPU_EXT.grcgwait
#endif


#define	CPU_isDI		(!(CPU_FLAG & I_FLAG))
#define	CPU_isEI		(CPU_FLAG & I_FLAG)
#define	CPU_CLI			CPU_FLAG &= ~I_FLAG;	\
						CPU_CORE.s.trap = 0;
#define	CPU_STI			CPU_FLAG |= I_FLAG;		\
						CPU_CORE.s.trap = (CPU_FLAG >> 8) & 1;
#define	CPU_A20EN(en)	i386v_a20en(en)

#define	CPU_INITIALIZE				i386v_initialize
#define	CPU_DEINITIALIZE			i386v_deinitialize
#define	CPU_RESET					i386v_reset
#define	CPU_CLEARPREFETCH()			
#define	CPU_INTERRUPT(vect, soft)	i386v_interrupt(vect)
#define	CPU_EXEC					i386v
#define	CPU_EXECV30					i386v
#define	CPU_SHUT					i386v_shut
#define	CPU_SETEXTSIZE(size)		i386v_setextsize((UINT32)(size) << 20)
#define	CPU_SETEMM(frame, addr)		i386v_setemm(frame, addr)

#define	CPU_STEPEXEC				i386v_step

