/*!
******************************************************************************

	@file	stdio.c

	Copyright (C) 2008-2009 Vsun86 Development Project. All rights reserved.

******************************************************************************
*/

#include <stdarg.h>
#include <stdio.h>

#include "../vmm/vsun86.h"
#include "../vmm/syscall.h"

int sprintf( char *str, const char *fmt, ... )
{
	va_list ap;
	int n;

	va_start( ap, fmt );
	n = vsprintf( str, fmt, ap );
	va_end( ap );

	return n;
}

int fprintf( FILE *fp, const char *fmt, ... )
{
	va_list ap;
	char tmp[1024];
	int n;

	va_start( ap, fmt );
	n = vsprintf( tmp, fmt, ap );
	if ( fp == stdout )			// 標準出力
		Vsun86_PutString( tmp );
	else if ( fp == stderr )	// 標準エラー出力
		Vsun86_OutputDebugString( tmp );
	va_end( ap );

	return n;
}

int printf( const char *fmt, ... )
{
	va_list ap;
	int n;

	va_start( ap, fmt );
	n = vprintf( fmt, ap );
	va_end( ap );

	return n;
}

int putchar( int c )
{
	Vsun86_PutChar( c );
	return c;
}

int puts( const char *s )
{
	Vsun86_PutString( s );
	return 0;
}
