/*!
******************************************************************************

	@file	math.c

	Copyright (C) 2008 Vsun86 Development Project. All rights reserved.

******************************************************************************
*/

#include <math.h>

double exp( double x )
{
	double result;

	__asm__ __volatile__ (					// st(0)			st(1)
		"fldl2e						\n\t"	// log2(e)			x
		"fmulp						\n\t"	// X = x*log2(e)	---
		"fld		%%st			\n\t"	// X				X
		"frndint					\n\t"	// int(X)			X
		"fxch						\n\t"	// X				int(X)
		"fsub		%%st(1), %%st	\n\t"	// X-int(X)			int(X)
		"f2xm1						\n\t"	// 2**(X-int(X))-1	int(X)
		"fld1						\n\t"
		"faddp						\n\t"	// 2**(X-int(X))	int(X)
		"fxch						\n\t"	// int(X)			2**(X-int(X))
		"fld1						\n\t"
		"fscale						\n\t"
		"fstp		%%st(1)			\n\t"	// 2**(int(X))		2**(X-int(X))
		"fmulp						\n\t"	// 2**X == e**x
		: "=t"(result)
		: "0"(x)
	);

	return result;
}

double log( double x )
{
	double result;

	__asm__ __volatile__ (					// st(0)			st(1)			st(2)
		"fld1						\n\t"	// 1.0				x				---
		"fldl2e						\n\t"	// log2(e)			1.0				x
		"fdivrp						\n\t"	// 1/log2(e)		x				---
		"fld		%%st(1)			\n\t"	// x				1/log2(e)		x
		"fyl2x						\n\t"	// log2(x)/log2(e)	x				---
		"fstp		%%st(1)			\n\t"	// log2(x)/log2(e)	---				---
		: "=t"(result)
		: "0"(x)
	);

	return result;
}

double pow( double x, double y )
{
	return exp( y*log(x) );
}

double sqrt( double x )
{
	double result;

	__asm__ __volatile__ ( "fsqrt" : "=t"(result) : "0"(x) );

	return result;
}
