#pragma once

#if !defined(WIN32_LEAN_AND_MEAN)
#	define WIN32_LEAN_AND_MEAN
#endif
#if !defined(VC_EXTRALEAN)
#	define VC_EXTRALEAN
#endif
#if !defined(STRICT)
#	define STRICT
#endif

#include <windows.h>

#include <string>
#include <list>

struct Registry {
public:
	typedef std::basic_string<TCHAR> tstring;
	struct Error {
		const LONG Code;
		Error(LONG code) : Code(code) { }
	};
	struct Node {
	private:
		const HKEY hkey;
		const tstring subkey;
		const tstring name;
		const tstring value;
		const std::list<const Node> children;
		static std::list<const Node> makeChildren(const Node& c0) { std::list<const Node> r; r.push_back(c0); return r; }
		static std::list<const Node> makeChildren(const Node& c0, const Node& c1) { std::list<const Node> r; r.push_back(c0); r.push_back(c1); return r; }
		static std::list<const Node> makeChildren(const Node& c0, const Node& c1, const Node& c2) { std::list<const Node> r; r.push_back(c0); r.push_back(c1); r.push_back(c2); return r; }
		static std::list<const Node> makeChildren(const Node& c0, const Node& c1, const Node& c2, const Node& c3) { std::list<const Node> r; r.push_back(c0); r.push_back(c1); r.push_back(c2); r.push_back(c3); return r; }
		Node(const HKEY k, const tstring &s, const tstring &n, const tstring &v) : hkey(k), subkey(s), name(n), value(v) { }
		Node(const HKEY k, const tstring &s, const tstring &n, const tstring &v, const Node &c0) : hkey(k), subkey(s), name(n), value(v), children(makeChildren(c0)) { }
		Node(const HKEY k, const tstring &s, const tstring &n, const tstring &v, const Node &c0, const Node &c1) : hkey(k), subkey(s), name(n), value(v), children(makeChildren(c0, c1)) { }
		Node(const HKEY k, const tstring &s, const tstring &n, const tstring &v, const Node &c0, const Node &c1, const Node &c2) : hkey(k), subkey(s), name(n), value(v), children(makeChildren(c0, c1, c2)) { }
		Node(const HKEY k, const tstring &s, const tstring &n, const tstring &v, const Node &c0, const Node &c1, const Node &c2, const Node &c3) : hkey(k), subkey(s), name(n), value(v), children(makeChildren(c0, c1, c2, c3)) { }
		void Create(HKEY h) const {
			if (hkey != 0) {
				for (auto i = children.begin(); i != children.end(); ++i) {
					i->Create(hkey);
				}
			} else if (!subkey.empty()) {
				HKEY k;
				LONG r = ::RegCreateKeyEx(h, subkey.c_str(), 0, nullptr, 0, KEY_ALL_ACCESS, nullptr, &k, nullptr);
				if (r != ERROR_SUCCESS) throw Error(r);
				for (auto i = children.begin(); i != children.end(); ++i) {
					i->Create(k);
				}
			} else {
				LONG r = ::RegSetValueEx(h, name.c_str(), 0, REG_SZ, reinterpret_cast<const BYTE *>(value.c_str()), sizeof(TCHAR) * (value.length() + 1));
				if (r != ERROR_SUCCESS) throw Error(r);
			}
		}
		bool Delete(HKEY h) const throw() {
			if (hkey != 0) {
				bool f = true;
				for (auto i = children.begin(); i != children.end(); ++i) {
					if (!i->Delete(hkey)) f = false;
				}
				return f;
			} else if (!subkey.empty()) {
				if (children.size() > 0) {
					HKEY k;
					LONG r = ::RegOpenKeyEx(h, subkey.c_str(), 0, KEY_ALL_ACCESS, &k);
					if (r != ERROR_SUCCESS) return false;
					for (auto i = children.begin(); i != children.end(); ++i) {
						i->Delete(k);
					}
					::RegCloseKey(k);
				}
				LONG r = ::RegDeleteKey(h, subkey.c_str());
				return r == ERROR_SUCCESS;
			} else {
				LONG r = ::RegDeleteValue(h, name.c_str());
				return r == ERROR_SUCCESS;
			}
		}
		friend Registry;
	};
	struct RootNode : Node {
		friend Registry;
	private:
		RootNode(Node &n) : Node(n) { }
	};
	struct KeyNode : Node {
		friend Registry;
	private:
		KeyNode(Node &n) : Node(n) { }
	};
	struct ValueNode : Node {
		friend Registry;
	private:
		ValueNode(Node &n) : Node(n) { }
	};
	static RootNode Root(HKEY hkey) { RootNode r(Node(hkey, tstring(), tstring(), tstring())); return r; }
	static RootNode Root(HKEY hkey, const KeyNode &c0) { RootNode r(Node(hkey, tstring(), tstring(), tstring(), c0)); return r; }
	static RootNode Root(HKEY hkey, const KeyNode &c0, const KeyNode &c1) { RootNode r(Node(hkey, tstring(), tstring(), tstring(), c0, c1)); return r; }
	static RootNode Root(HKEY hkey, const KeyNode &c0, const KeyNode &c1, const KeyNode &c2) { RootNode r(Node(hkey, tstring(), tstring(), tstring(), c0, c1, c2)); return r; }
	static RootNode Root(HKEY hkey, const KeyNode &c0, const KeyNode &c1, const KeyNode &c2, const KeyNode &c3) { RootNode r(Node(hkey, tstring(), tstring(), tstring(), c0, c1, c2, c3)); return r; }
	static KeyNode Key(const tstring &s) { RootNode r(Node(0, s, tstring(), tstring())); return r; }
	static KeyNode Key(const tstring &s, const KeyNode &c0) { RootNode r(Node(0, s, tstring(), tstring(), c0)); return r; }
	static KeyNode Key(const tstring &s, const ValueNode &c0) { RootNode r(Node(0, s, tstring(), tstring(), c0)); return r; }
	static KeyNode Key(const tstring &s, const KeyNode &c0, const KeyNode &c1) { RootNode r(Node(0, s, tstring(), tstring(), c0, c1)); return r; }
	static KeyNode Key(const tstring &s, const ValueNode &c0, const KeyNode &c1) { RootNode r(Node(0, s, tstring(), tstring(), c0, c1)); return r; }
	static KeyNode Key(const tstring &s, const ValueNode &c0, const ValueNode &c1) { RootNode r(Node(0, s, tstring(), tstring(), c0, c1)); return r; }
	static KeyNode Key(const tstring &s, const KeyNode &c0, const KeyNode &c1, const KeyNode &c2) { RootNode r(Node(0, s, tstring(), tstring(), c0, c1, c2)); return r; }
	static KeyNode Key(const tstring &s, const ValueNode &c0, const KeyNode &c1, const KeyNode &c2) { RootNode r(Node(0, s, tstring(), tstring(), c0, c1, c2)); return r; }
	static KeyNode Key(const tstring &s, const ValueNode &c0, const ValueNode &c1, const KeyNode &c2) { RootNode r(Node(0, s, tstring(), tstring(), c0, c1, c2)); return r; }
	static KeyNode Key(const tstring &s, const ValueNode &c0, const ValueNode &c1, const ValueNode &c2) { RootNode r(Node(0, s, tstring(), tstring(), c0, c1, c2)); return r; }
	static KeyNode Key(const tstring &s, const KeyNode &c0, const KeyNode &c1, const KeyNode &c2, const KeyNode &c3) { RootNode r(Node(0, s, tstring(), tstring(), c0, c1, c2, c3)); return r; }
	static KeyNode Key(const tstring &s, const ValueNode &c0, const KeyNode &c1, const KeyNode &c2, const KeyNode &c3) { RootNode r(Node(0, s, tstring(), tstring(), c0, c1, c2, c3)); return r; }
	static KeyNode Key(const tstring &s, const ValueNode &c0, const ValueNode &c1, const KeyNode &c2, const KeyNode &c3) { RootNode r(Node(0, s, tstring(), tstring(), c0, c1, c2, c3)); return r; }
	static KeyNode Key(const tstring &s, const ValueNode &c0, const ValueNode &c1, const ValueNode &c2, const KeyNode &c3) { RootNode r(Node(0, s, tstring(), tstring(), c0, c1, c2, c3)); return r; }
	static KeyNode Key(const tstring &s, const ValueNode &c0, const ValueNode &c1, const ValueNode &c2, const ValueNode &c3) { RootNode r(Node(0, s, tstring(), tstring(), c0, c1, c2, c3)); return r; }
	static ValueNode Value(const tstring &n, const tstring &v) { ValueNode r(Node(0, tstring(), n, v)); return r; }
	Registry(const RootNode& c0) : children(Node::makeChildren(c0)) { }
	Registry(const RootNode& c0, const RootNode& c1) : children(Node::makeChildren(c0, c1)) { }
	Registry(const RootNode& c0, const RootNode& c1, const RootNode& c2) : children(Node::makeChildren(c0, c1, c2)) { }
	Registry(const RootNode& c0, const RootNode& c1, const RootNode& c2, const RootNode& c3) : children(Node::makeChildren(c0, c1, c2, c3)) { }
	void Create(void) {
		for (auto i = children.begin(); i != children.end(); ++i) {
			i->Create(0);
		}
	}
	bool Delete(void) {
		bool f = true;
		for (auto i = children.begin(); i != children.end(); ++i) {
			if (!i->Delete(0)) f = false;
		}
		return f;
	}
private:
	const std::list<const Node> children;
};
