#pragma once

#if !defined(WIN32_LEAN_AND_MEAN)
#	define WIN32_LEAN_AND_MEAN
#endif
#if !defined(VC_EXTRALEAN)
#	define VC_EXTRALEAN
#endif
#if !defined(STRICT)
#	define STRICT
#endif

#include <windows.h>
#include <oleauto.h>
#include <comutil.h>

#include "exception.h"

struct SafeArray {
	template<typename T> SafeArray(T first, T last) : Data(::SafeArrayCreateVector(VT_VARIANT, 0, std::distance(first, last) + 1)) {
		try {
			AccessData ad(Data);
			VARIANT *p = static_cast<VARIANT *>(ad.Data);
			for (T i = first; i != last; ++i) {
				::VariantCopy(p++, &_variant_t(*i).GetVARIANT());
			}
		} catch (...) {
			::SafeArrayDestroy(Data);
			throw;
		}
	}
	~SafeArray() { ::SafeArrayDestroy(Data); }
	SAFEARRAY *const Data;
private:
	SafeArray(const SafeArray &);
	struct AccessData {
		AccessData(SAFEARRAY *sa) : safearray(sa), Data(GetAddress(sa)) { }
		~AccessData(void) { ::SafeArrayUnaccessData(safearray); }
		void *const Data;
	private:
		SAFEARRAY *const safearray;
		AccessData(const AccessData &);
		static void *GetAddress(SAFEARRAY *sa) {
			void *result;
			_com_check(::SafeArrayAccessData(sa, &result));
			return result;
		}
	};
};
