﻿package
{
	import flash.display.*;
	import flash.events.Event;
	import flash.media.*;
	import flash.net.URLRequest;
	import net.hires.debug.*;
	import org.b2ox.flash3d.*;
	import org.b2ox.flash3d.MikuMikuDance.*;
	import org.b2ox.flash3d.MikuMikuDance.utils.*;
	import org.b2ox.thread.*;
	import org.libspark.thread.*;
	import org.libspark.thread.threads.net.*;
	import org.libspark.thread.threads.utils.*;
	import org.libspark.thread.utils.*;
	import mx.controls.*;

	public class PMDViewerTEST extends Thread
	{
		private var pmdviewer:PMDViewer;

		//[Embed(source = '../img/vocaloplus.png')] public var logoCls:Class;
		// Flex4でSVGを扱う場合は Show Deprecation Warningsをfalseにしておく必要有り。将来的にはSVGからFXGに移行しろってことらしい。
		[Embed(source = '../img/vocaloplus.svg')][Bindable] public var logoSvgCls:Class;
		[Embed(source = '../mp3/vocaloplus_eyecatch.mp3')] public var eyecatchCls:Class;


		static public function init(pmdviewer:PMDViewer, msgArea:Text):void
		{
			new PMDViewerTEST(pmdviewer, msgArea).start();
		}

		private var msgArea:Text;
		public function PMDViewerTEST(pmdviewer:PMDViewer, msgArea:Text):void
		{
			this.pmdviewer = pmdviewer;
			this.msgArea = msgArea;
		}

		override protected function run():void
		{
			// FPSなどの表示
			var stat:Stats = new Stats();
			stat.y = 30;
			pmdviewer.addChild(stat);

			// ロゴ画像の貼り付け
			//var logo:Bitmap = new logoCls();
			var logo:Sprite = new logoSvgCls();
			logo.scaleX = 0.09;
			logo.scaleY = 0.09;
			pmdviewer.addChild(logo);

			Sound(new eyecatchCls()).play(); // サウンドロゴの再生

			runSub();
		}

		private var mmd:MikuMikuDance;
		private function runSub():void
		{
			var url:String = "nanoha1052.zip://nanoha1052.pmd";
			var scale:Number = 15;
			mmd = new MikuMikuDance();
			//mmd.looping = true;
			mmd.x = 0;
			mmd.y = -150;
			mmd.z = 0;

			mmd.addEventListener(MikuMikuDance.MOTION_ADDED, function (e:Event):void { msgArea.text = mmd.motionName } );
			mmd.addEventListener(MikuMikuDance.MOTION_CHANGED, function (e:Event):void { msgArea.text = mmd.motionName } );

			var sloaders:SerialExecutor = new SerialExecutor();
			trace("addThread: pmdLoader(" + url + "," + scale + ")" );
			sloaders.addThread(mmd.makePMDLoader(url, scale));
			sloaders.addThread(new TraceThread("addMMD:" + url));
			sloaders.addThread(new FunctionThread(pmdviewer.addMMD, mmd));
			sloaders.addThread(mmd.makeVMDLoader("motions.zip://popipo.vmd", "popipo"));
			sloaders.addThread(mmd.makeVMDLoader("motions.zip://walk.vmd", "walk"));

			sloaders.start();
			sloaders.join();
			next(motionMix);
		}

		private function motionMix():void
		{
			trace("[DEBUG] motionMix");
			var popipo:IVMDController = mmd.getMotion("popipo");
			var walk:IVMDController = mmd.getMotion("walk");
			var smotion:IVMDController = new VMDControllerSerial(walk, popipo);
			smotion.looping = true;
			mmd.addMotion("walk;popipo", smotion);

			var nop:IVMDController = new VMDControllerNop(walk.tween.duration);
			var rmotion:IVMDController = new VMDControllerRandom(walk, nop, 0.7);
			rmotion.looping = true;
			mmd.addMotion("walk or nop", rmotion);
			
			var tmotion:IVMDController = TalkMotion.create(mmd.pmdController, "おおんいいおおんんいいおおんいいおおおおおんんん", 6);
			var mmotion:IVMDController = new VMDControllerMix(popipo, tmotion);
			mmotion.looping = true;
			mmd.addMotion("popipo + 口パク", mmotion);

			var wink:IVMDController = WinkMotion.create(mmd.pmdController);
			nop = new VMDControllerNop(wink.tween.duration);
			var wmotion:IVMDController = new VMDControllerRandom(wink, nop, 0.3);
			var xmotion:IVMDController = new VMDControllerMix(mmotion, wmotion);
			xmotion.looping = true;
			mmd.addMotion("popipo + 口パク + wink", xmotion);
		}
	}
}
