﻿/**
* @author b2ox
*/
package vocaloplus.utils
{
	import flash.display.Bitmap;
	import flash.events.*;
	import org.b2ox.pv3d.MikuMikuDance.*;
	import org.b2ox.pv3d.MikuMikuDance;
	import vocaloplus.modules.IModelModule;

	public class ModelTranslator
	{
		public static function toMikuMikuDance(modelMod:IModelModule, scaling:Number = 1.0):MikuMikuDance
		{
			trace("[DEBUG] ModelTranslator");
			var _mmd:MikuMikuDance = new MikuMikuDance();
			var _pmdController:PMDController = _mmd.pmdController;
			var pmd:Object = modelMod.content;
			var textures:Array = modelMod.textures;
			_mmd.scaling = scaling;

			//------------------------------------
			// 各種一時変数
			var x:Number, y:Number, z:Number;
			var i:int, j:int;
			var count0:uint;

			//------------------------------------
			// ヘッダ
			_mmd.version = pmd.mmdVersion;
			_mmd.modelName = pmd.modelName;
			_mmd.comment = pmd.modelComment;

			trace("--------------------------------------------------");
			trace("モデル" + modelMod.name + " 変換開始");
			trace(_mmd.modelName);
			trace(_mmd.comment);

			//------------------------------------
			// 頂点
			var vertex:Array = pmd.vertex;
			var vertex_count:uint = vertex.length;
			_mmd.initVertexUVarrays(vertex_count);
			_pmdController.initBind(vertex_count);
			for (i = 0; i < vertex_count; i++) {
				x = vertex[i].x * scaling;
				y = vertex[i].y * scaling;
				z = vertex[i].z * scaling;
				_mmd.regVertex(i, x, y, z);
				_pmdController.regVertex(i, x, y, z);
				_mmd.regUV(i, vertex[i].u, vertex[i].v);
				// (i, bone0, bone1, weight, edge)
				_pmdController.regBind(i, vertex[i].bone0, vertex[i].bone1, vertex[i].weight, vertex[i].edge);
			}
			trace("model translator: 頂点登録完了。頂点数: " + vertex_count);

			//------------------------------------
			// 面
			var face:Array = pmd.face;
			var face_count:uint = face.length;
			_mmd.initTriangleArray(face_count);
			for (i = 0; i < face_count; i++) {
				_mmd.regTriangle(i, face[i].v0, face[i].v1, face[i].v2);
			}
			trace("model translator: 面登録完了。面数: "+face_count);

			//------------------------------------
			// 材質
			_mmd.initMaterials();
			var material:Array = pmd.material;
			var material_count:uint = material.length;
			var faces:Array = _mmd.geometry.faces;
			var faceOffset:uint = 0;
			var fillColor:uint = 0;
			for (i = 0; i < material_count; i++) {
				fillColor = material[i].color;
				count0 = material[i].applyFaces; // 適用する面数
				_mmd.regMaterialBase(
					"mat" + i.toString(),
					material[i].textureID < 0 ? null : (textures[material[i].textureID] as Bitmap).bitmapData,
					fillColor, faceOffset, count0);
				faceOffset += count0;
			}
			trace("model translator: 材質登録完了。材質数: " + material_count);

			//------------------------------------
			// ボーン
			var bone:Array = pmd.bone;
			var bone_count:uint = bone.length;
			var pbone:PMDBone;
			for (i = 0; i < bone_count; i++) {
				pbone = new PMDBone(bone[i].boneName, bone[i].parentID, bone[i].tailID, bone[i].boneType, bone[i].IKparentID);
				pbone.initTranslation(bone[i].x * scaling, bone[i].y * scaling, bone[i].z * scaling);
				_pmdController.addBone(pbone);
				trace("bone[" + i + "] = \"" + pbone.name + "\"");
			}
			_pmdController.bindBones();
			trace("model translator: ボーン処理完了。ボーン数: " + bone_count);

			//------------------------------------
			// IK
			var IK:Array = pmd.IK;
			var IK_count:uint = IK.length;
			for (i = 0; i < IK_count; i++) {
				_pmdController.regIKparams(IK[i].boneID, IK[i].iterations, IK[i].weight, IK[i].chain);
			}
			trace("model translator: IK処理完了。IK数: " + IK_count);

			//------------------------------------
			// Skin
			var pskin:PMDSkin;
			var skin:Array = pmd.skin;
			var Skin_count:uint = skin.length;
			for (i = 0; i < Skin_count; i++) {
				pskin = new PMDSkin(skin[i].skinName, skin[i].vertex.length, skin[i].skinType);
				count0 = pskin.size;
				for (j = 0; j < count0; j++) {
					var sv:Object = skin[i].vertex[j];
					pskin.setVertex(j, sv.base, sv.x * scaling, sv.y * scaling, sv.z * scaling);
				}
				_pmdController.addSkin(pskin);
				trace("skin[" + i + "] = \"" + pskin.name + "\", type:" + pskin.type);
			}
			trace("model translator: Skin処理完了。Skin数: " + Skin_count);

			trace("モデル" + modelMod.name + "処理完了")
			trace("--------------------------------------------------");

			return _mmd;
		}
	}
}

