﻿package org.b2ox.betweenas3
{
	import org.libspark.betweenas3.core.ticker.ITicker;
	import org.libspark.betweenas3.core.tweens.AbstractTween;
	import org.libspark.betweenas3.core.tweens.IITween;
	import org.libspark.betweenas3.tweens.ITween;
	
	/**
	 * ...
	 * @author b2ox
	 */
	public class FuncTween extends AbstractTween
	{
		private var _updateFunc:Function = null;
		public function FuncTween(ticker:ITicker, position:Number, duration:Number, updateFunc:Function)
		{
			super(ticker, position);
			if (updateFunc == null) throw new Error("updateFuncが必要です");
			if (duration < 0) throw new Error("durationが不正です");
			_duration = duration;
			_updateFunc = updateFunc;
		}
		override protected function internalUpdate(time:Number):void 
		{
			_updateFunc(time);
		}
		/** updateFuncはclone元と共有する点に注意
		 */
		override protected function newInstance():AbstractTween 
		{
			return new FuncTween(ticker, position, duration, _updateFunc);
		}
		/**
		 * baseTweenのtickerとdurationとupdateFuncからFuncTweenを作ります
		 * @param	updateFunc
		 * @param	baseTween
		 */
		static public function create(updateFunc:Function, baseTween:ITween):FuncTween
		{
			return new FuncTween((baseTween as IITween).ticker, 0, baseTween.duration, updateFunc);
		}
	}
}