﻿/**
 * @author b2ox
 */
package org.b2ox.pv3d.MikuMikuDance
{
	import org.b2ox.pv3d.MikuMikuDance.*;
	import org.b2ox.pv3d.Utils;

	/**
	 * スキンパラメータ列の格納
	 */
	public class VMDSkinParamSequence
	{
		private var keyFrame:Vector.<KeyFrameInfo> = new Vector.<KeyFrameInfo>();
		private var frameLength:int = 0;
		public var skinName:String;

		// スキンパラメータは重み(Number型)のみなのでVMDSkinParamクラスは作らない

		/**
		 * コンストラクタ.
		 * @param	skinName	パラメータ列の対象となるスキン名
		 */
		public function VMDSkinParamSequence(skinName:String):void 
		{
			this.skinName = skinName;
		}

		/**
		 * パラメータ(重み)の追加
		 * @param	frameNo	追加先のフレーム番号
		 * @param	weight
		 */
		public function addSkinParam(frameNo:int, weight:Number):void
		{
			// 既に登録済みのフレームの場合は上書き
			for (var i:int = keyFrame.length-1; i >= 0; i--)
			{
				if (keyFrame[i].frameNo == frameNo) {
					keyFrame[i].weight = weight;
					return;
				}
			}
			keyFrame.push(new KeyFrameInfo(frameNo, weight));
		}

		/**
		 * パラメータ列の整理.
		 * 全パラメータ登録後に実行すること
		 * @param	frameLength
		 */
		public function fixSequence(frameLength:int):void
		{
			keyFrame = keyFrame.sort(KeyFrameInfo.compare);
			keyFrame.fixed = true;
			this.frameLength = frameLength;
			trace("skin["+skinName+"]: キーフレーム総数 "+keyFrame.length);
		}

		/**
		 * 2分探索でkeyFrame配列中にframeNoが所属する区間の先頭を求める
		 * @param	start
		 * @param	end
		 * @param	frameNo
		 * @return
		 */
		private function searchRange(start:int, end:int, frameNo:int):int
		{
			if (keyFrame[start].frameNo == frameNo || end == start + 1) return start;
			var n:int = (start + end) / 2;
			if (frameNo < keyFrame[n].frameNo) return searchRange(start, n, frameNo);
			return searchRange(n, end, frameNo);
		}

		/**
		 * frameNoにおけるスキンパラメータを得る
		 * @param	frameNo
		 * @return
		 */
		public function getSkinParam(frameNo: int):Number
		{
			var n:int = keyFrame.length - 1;
			var kf:KeyFrameInfo = keyFrame[n];
			if (kf.frameNo > frameNo) kf = keyFrame[searchRange(0, n, frameNo)];
			return kf.weight;
		}
	}
}

class KeyFrameInfo
{
	public var frameNo:int;
	public var weight:Number;

	public function KeyFrameInfo(frameNo:int, weight:Number):void
	{
		this.frameNo = frameNo;
		this.weight = weight;
	}
	
	public static function compare(a:KeyFrameInfo, b:KeyFrameInfo):Number
	{
		return (a.frameNo == b.frameNo) ? 0 : (a.frameNo < b.frameNo) ? -1 : 1;
	}
}