﻿package
{
	import flash.utils.ByteArray;
	import flash.utils.Endian;
	import flash.filesystem.File;
	import flash.filesystem.FileMode;
	import flash.filesystem.FileStream;
	import org.libspark.thread.Thread;

	/**
	 * ...
	 * @author b2ox
	 */
	public class VMD2AS extends Thread
	{
		private var inFile:File;
		private var class_name:String, module_name:String;
		private var log:Function;
		private var outFile:File;
		private var vmdObj:Object;

		public function VMD2AS(inFile:File, class_name:String, module_name:String, log:Function):void
		{
			this.inFile = inFile;
			this.class_name = class_name;
			this.module_name = module_name;
			this.log = log;
		}

		override protected function run():void
		{
			loadPMD();
			next(writeAS3);
		}

		private function loadPMD():void
		{
			outFile = inFile.parent.resolvePath(class_name + ".as");
			log( "変換開始: " + inFile.nativePath + " → " + outFile.nativePath );

			const sjis:String = "shift-jis";
			var vmd:FileStream = new FileStream();
			try
			{
				vmd.open(inFile, FileMode.READ);
				vmd.endian = Endian.LITTLE_ENDIAN;

				log( "VMDロード開始" );
				// VMD形式について http://jbbs.livedoor.jp/bbs/read.cgi/music/23040/1219738115/967-983

				//------------------------------------
				// 各種一時変数
				var i:int, frame:int;
				var param:Object;
				var ary:Array;

				//------------------------------------
				// ヘッダ
				var header:String = vmd.readMultiByte(30, sjis);
				if (header.indexOf("Vocaloid Motion Data 0002") != 0) throw new Error("VMD形式ではありません");
				var model_name:String = vmd.readMultiByte(20, sjis);

				//------------------------------------
				// ボーン
				var bone_data_count:uint = vmd.readUnsignedInt();
				var bones:Object = new Object();
				var bary:ByteArray = new ByteArray();

				for (i = 0; i < bone_data_count; i++)
				{
					var boneName:String = vmd.readMultiByte(15, sjis);
					param = {
						frame: vmd.readUnsignedInt(),
						move: { x: vmd.readFloat(), y: vmd.readFloat(), z: vmd.readFloat() },
						rotation: { x: -vmd.readFloat(), y: -vmd.readFloat(), z: -vmd.readFloat(), w: vmd.readFloat() }
					};

					// interpolations
					vmd.readBytes(bary, 0, 64); // interpolation bary[4*j]以外の値は不要

					// interpolationX～interpolationZ はtranslationに関する補間
					var j:int = 0;
					param.ipX = [ bary[j], bary[j + 4], bary[j + 8], bary[j + 12] ];
					j += 16;
					param.ipY = [ bary[j], bary[j + 4], bary[j + 8], bary[j + 12] ];
					j += 16;
					param.ipZ = [ bary[j], bary[j + 4], bary[j + 8], bary[j + 12] ];

					// interpolationRotはrotationに関する補間
					j += 16;
					param.ipR = [ bary[j], bary[j + 4], bary[j + 8], bary[j + 12] ];

					if (bones[boneName] == null) bones[boneName] = [];
					bones[boneName].push(param);
				}
				for each (ary in bones) ary.sortOn(["frame"], [Array.NUMERIC]);

				//------------------------------------
				// Skin
				var skins:Object = new Object();
				var skin_data_count:uint = vmd.readUnsignedInt();
				for (i = 0; i < skin_data_count; i++)
				{
					var skinName:String = vmd.readMultiByte(15, sjis);
					if (skins[skinName] == null) skins[skinName] = [];
					skins[skinName].push( { frame: vmd.readUnsignedInt(), weight: vmd.readFloat() } );
				}
				for each (ary in skins) ary.sortOn(["frame"], [Array.NUMERIC]);

				//------------------------------------
				// カメラや光源のデータが続くが、今回は必要ないので無視
				vmdObj = { boneParams: bones, skinParams: skins };

				log( "VMDロード完了" );

				log("書き出し開始(時間がかかります)"); // writeAS3に置きたいけどそれだとタイミング的にうまく表示できない
			}
			catch (e:Error)
			{
				trace(e.getStackTrace());
			}
			finally
			{
				vmd.close();
			}
		}

		//------------------------------------
		// asファイルの書き出し
		private function writeAS3():void 
		{
			var writer:FileStream = new FileStream();
			try
			{
				writer.open(outFile, FileMode.WRITE);
				writer.writeUTFBytes("/**\n * @mxmlc -source-path+=src -load-externs=report.xml -debug=false -o bin/" + class_name + ".swf\n */\n");
				writer.writeUTFBytes("package vocaloplus.modules.motions { // 適宜変更すること\n");
				writer.writeUTFBytes("\timport mx.modules.ModuleBase;\n");
				writer.writeUTFBytes("\timport vocaloplus.modules.IMotionModule;\n");
				writer.writeUTFBytes("\tpublic class " + class_name + " extends ModuleBase implements IMotionModule { // 適宜変更すること\n");
				writer.writeUTFBytes("\t\tpublic const moduleName:String = \"" + module_name + "\"; // 適宜変更すること\n");
				writer.writeUTFBytes("\t\t//-- 以下は変更禁止 --\n");
				writer.writeUTFBytes("\t\tpublic function get type():String { return \"motion\"; }\n");
				writer.writeUTFBytes("\t\tpublic function get name():String { return moduleName; }\n");
				writer.writeUTFBytes("\t\tpublic function get content():Object { return motionParams; }\n");
				writer.writeUTFBytes("\t\tprivate const motionParams:Object = ");
				new JSONEncodeWriter(writer, vmdObj).write();
				writer.writeUTFBytes(";\n");
				writer.writeUTFBytes("\t}\n");
				writer.writeUTFBytes("}\n");

				log("書き出し完了");
			}
			catch (e:Error)
			{
				trace(e.getStackTrace());
			}
			finally
			{
				writer.close();
			}
		}
	}
}

