﻿package
{
	import flash.utils.Endian;
	import flash.filesystem.File;
	import flash.filesystem.FileMode;
	import flash.filesystem.FileStream;
	import org.libspark.thread.Thread;

	/**
	 * ...
	 * @author b2ox
	 */
	public class PMD2AS extends Thread
	{
		private var inFile:File;
		private var class_name:String, module_name:String;
		private var log:Function;
		private var outFile:File;
		private var pmdObj:Object;
		private var textureArray:Array;

		public function PMD2AS(inFile:File, class_name:String, module_name:String, log:Function):void
		{
			this.inFile = inFile;
			this.class_name = class_name;
			this.module_name = module_name;
			this.log = log;
		}

		override protected function run():void
		{
			loadPMD();
			next(writeAS3);
		}

		private function loadPMD():void
		{
			outFile = inFile.parent.resolvePath(class_name + ".as");
			log( "変換開始: " + inFile.nativePath + " → " + outFile.nativePath );

			//------------------------------------
			const sjis:String = "shift-jis";
			const skip_noneeds:Boolean = true; // 必要ない部分を読み飛ばす

			var pmd:FileStream = new FileStream();
			try
			{
				pmd.open(inFile, FileMode.READ);
				pmd.endian = Endian.LITTLE_ENDIAN;
				log( "PMDロード開始" );
				// PMD形式について http://blog.goo.ne.jp/torisu_tetosuki/e/209ad341d3ece2b1b4df24abf619d6e4

				//------------------------------------
				// 各種一時変数
				var i:int, j:int, k:int;
				var count0:uint;
				var str:String;
				var tObj:Object;

				//------------------------------------
				// ヘッダ
				if (pmd.readMultiByte(3, sjis) != "Pmd") throw new Error("PMD形式ではありません。");
				pmdObj = { mmdVersion: pmd.readFloat(), modelName: pmd.readMultiByte(20, sjis), modelComment: pmd.readMultiByte(256, sjis) };
				log(pmdObj.modelName);
				log(pmdObj.modelComment);

				//------------------------------------
				// 頂点
				var vertex_count:uint = pmd.readUnsignedInt();
				var vertexArray:Array = new Array(vertex_count);
				for (i = 0; i < vertex_count; i++) {
					tObj = { x: pmd.readFloat(), y: pmd.readFloat(), z: pmd.readFloat() }; // 頂点座標
					// 頂点法線
					if (skip_noneeds) // 読み飛ばし
					{
						pmd.position += 12;
					} else {
						tObj.nx = pmd.readFloat();
						tObj.ny = pmd.readFloat();
						tObj.nz = pmd.readFloat();
					}
					// UV座標
					tObj.u = pmd.readFloat();
					tObj.v = 1.0 - pmd.readFloat();
					// ボーン
					tObj.bone0 = pmd.readUnsignedShort();
					tObj.bone1 = pmd.readUnsignedShort();
					tObj.weight = pmd.readByte();
					tObj.edge = pmd.readByte();
					vertexArray[i] = tObj;
				}
				pmdObj.vertex = vertexArray;
				log("parser: 頂点登録完了。頂点数: " + vertex_count);

				//------------------------------------
				// 面
				var face_count:uint = pmd.readUnsignedInt() / 3; // 各面3個の頂点インデックス
				var faceArray:Array = new Array(face_count);
				for (i = 0; i < face_count; i++) {
					faceArray[i] = { v0: pmd.readUnsignedShort(), v1: pmd.readUnsignedShort(), v2: pmd.readUnsignedShort() };
				}
				pmdObj.face = faceArray;
				log("parser: 面登録完了。面数: "+face_count);

				//------------------------------------
				// 材質
				var material_count:uint = pmd.readUnsignedInt();
				var materialArray:Array = new Array(material_count);
				textureArray = new Array();
				var textureID:int;

//				var faceOffset:uint = 0;
				function rgb(r:Number, g:Number, b:Number):uint
				{
					return (int(r*255) << 16) | (int(g*255) << 8) | int(b*255);
				}
				for (i = 0; i < material_count; i++) {
					tObj = { color: rgb(pmd.readFloat(), pmd.readFloat(), pmd.readFloat()), textureID: -1 };
					if (skip_noneeds) // 読み飛ばし
					{
						pmd.position += 34;
					} else {
						tObj.alpha = pmd.readFloat();
						tObj.specularity = pmd.readFloat();
						tObj.specular = rgb(pmd.readFloat(), pmd.readFloat(), pmd.readFloat());
						tObj.ambient = rgb(pmd.readFloat(), pmd.readFloat(), pmd.readFloat());
						tObj.toon = pmd.readByte();
						tObj.edge = pmd.readByte();
					}
					count0 = pmd.readUnsignedInt() / 3; // 適用する面数
					tObj.applyFaces = count0;
					str = pmd.readMultiByte(20, sjis); // texture
					if (str != "")
					{
						textureID = textureArray.lastIndexOf(str);
						if (textureID < 0)
						{
							textureID =  textureArray.length;
							textureArray.push(str);
						}
						tObj.textureID = textureID;
					}
					materialArray[i] = tObj;
//					for (j = 0, k = faceOffset; j < count0; j++, k++) faceArray[k].materialID = i;
//					faceOffset += count0;
				}
				pmdObj.material = materialArray;
				log("parser: 材質登録完了。材質数: " + material_count);

				//------------------------------------
				// ボーン
				var bone_count:uint = pmd.readUnsignedShort();
				var boneArray:Array = new Array(bone_count);
				for (i = 0; i < bone_count; i++) {
					boneArray[i] = {
						boneName: pmd.readMultiByte(20, sjis),
						parentID: pmd.readUnsignedShort(),
						tailID: pmd.readUnsignedShort(),
						boneType: pmd.readByte(),
						IKparentID: pmd.readUnsignedShort(),
						x: pmd.readFloat(), y: pmd.readFloat(), z: pmd.readFloat()
					};
				}
				pmdObj.bone = boneArray;
				log("parser: ボーン処理完了。ボーン数: " + bone_count);

				//------------------------------------
				// IK
				var IK_count:uint = pmd.readUnsignedShort();
				var IKArray:Array = new Array(IK_count);
				for (i = 0; i < IK_count; i++) {
					tObj = { boneID: pmd.readUnsignedShort() };
					k = pmd.readUnsignedShort(); // effector id(chain top)
					count0 = pmd.readUnsignedByte() + 1;
					var chain:Array = new Array(count0);
					chain[0] = k;
					tObj.iterations = pmd.readUnsignedShort();
					tObj.weight = pmd.readFloat();
					for (j = 1; j < count0; j++) {
						chain[j] = pmd.readUnsignedShort(); // chain id
					}
					tObj.chain = chain;
					IKArray[i] = tObj;
				}
				pmdObj.IK = IKArray;
				log("parser: IK処理完了。IK数: " + IK_count);

				//------------------------------------
				// Skin
				var Skin_count:uint = pmd.readUnsignedShort();
				var SkinArray:Array = new Array(Skin_count);
				for (i = 0; i < Skin_count; i++) {
					SkinArray[i] = { skinName: pmd.readMultiByte(20, sjis) };
					count0 = pmd.readUnsignedInt();
					SkinArray[i].skinType = pmd.readByte();
					var skinVertex:Array = new Array(count0);
					for (j = 0; j < count0; j++) {
						// base skin の index, base skinからの変移(x,y,z)
						skinVertex[j] = { base: pmd.readUnsignedInt(), x: pmd.readFloat(), y: pmd.readFloat(), z: pmd.readFloat() };
					}
					SkinArray[i].vertex = skinVertex;
				}
				pmdObj.skin = SkinArray;
				log("parser: Skin処理完了。Skin数: " + Skin_count);

				// 追加的な情報もあるけどここでは省略
				log("PMDロード完了");

				log("書き出し開始(時間がかかります)"); // writeAS3に置きたいけどそれだとタイミング的にうまく表示できない
			}
			catch (e:Error)
			{
				log(e.getStackTrace());
			}
			finally
			{
				pmd.close();
			}
		}

		//------------------------------------
		// asファイルの書き出し
		private function writeAS3():void 
		{
			var writer:FileStream = new FileStream();
			try
			{
				writer.open(outFile, FileMode.WRITE);
				writer.writeUTFBytes("/**\n * @mxmlc -source-path+=src -load-externs=report.xml -debug=false -o bin/" + class_name + ".swf\n */\n");
				writer.writeUTFBytes("package vocaloplus.modules.models." + class_name + " { // 適宜変更すること\n");
				writer.writeUTFBytes("\timport mx.modules.ModuleBase;\n");
				writer.writeUTFBytes("\timport flash.display.Bitmap;\n");
				writer.writeUTFBytes("\timport vocaloplus.modules.IModelModule;\n");
				writer.writeUTFBytes("\tpublic class " + class_name + " extends ModuleBase implements IModelModule { // 適宜変更すること\n");
						writer.writeUTFBytes("\t\tpublic const moduleName:String = \"" + module_name + "\"; // 適宜変更すること\n");
				if (textureArray.length > 0) writer.writeUTFBytes("\t\t// 以下ファイル名のみ適宜変更すること\n");
				for (var i:int = 0; i < textureArray.length; i++ ) {
					writer.writeUTFBytes("\t\t[Embed(source=\"" + textureArray[i] + "\")] private var textureCls" + i.toString() + ":Class;\n");
				}
				writer.writeUTFBytes("\t\t//-- 以下は変更禁止 --\n");
				writer.writeUTFBytes("\t\tpublic const _textures:Array = [\n");
				for ( i = 0; i < textureArray.length; i++ ) {
					writer.writeUTFBytes("\t\t\tnew textureCls" + i.toString() + "() as Bitmap" + (i == textureArray.length-1 ? "\n" : ",\n"));
				}
				writer.writeUTFBytes("\t\t];\n");
				writer.writeUTFBytes("\t\tpublic function get type():String { return \"model\"; }\n");
				writer.writeUTFBytes("\t\tpublic function get name():String { return moduleName; }\n");
				writer.writeUTFBytes("\t\tpublic function get content():Object { return model; }\n");
				writer.writeUTFBytes("\t\tpublic function get textures():Array { return _textures; }\n");
				writer.writeUTFBytes("\t\tprivate const model:Object = ");
				new JSONEncodeWriter(writer, pmdObj).write();
				writer.writeUTFBytes(";\n");
				writer.writeUTFBytes("\t}\n");
				writer.writeUTFBytes("}\n");

				log("書き出し完了");
			}
			catch (e:Error)
			{
				log(e.getStackTrace());
			}
			finally
			{
				writer.close();
			}
		}
	}
}

