﻿/**
 * MikuMikuDance VMD形式再生用スキンパラメータ列
 *
 * @author b2ox
 */
package org.b2ox.pv3d.MikuMikuDance
{
	import org.b2ox.pv3d.MikuMikuDance.*;
	import org.b2ox.pv3d.Utils;

	/**
	 * スキンパラメータ列の格納
	 */
	public class VMDSkinParamSequence
	{
		private var keyFrame:Vector.<KeyFrameInfo> = new Vector.<KeyFrameInfo>();
		private var frameLength:int = 0;
		public var skinName:String;

		// スキンパラメータは重み(Number型)のみなのでVMDSkinParamクラスは作らない

		public function VMDSkinParamSequence(skinName:String):void 
		{
			this.skinName = skinName;
		}

		public function addSkinParam(frameNo:int, weight:Number):void
		{
			// 既に登録済みのフレームの場合は上書き
			for (var i:int = keyFrame.length-1; i >= 0; i--)
			{
				if (keyFrame[i].frameNo == frameNo) {
					keyFrame[i].weight = weight;
					return;
				}
			}
			keyFrame.push(new KeyFrameInfo(frameNo, weight));
		}

		public function fixSequence(frameLength:int):void
		{
			keyFrame = keyFrame.sort(KeyFrameInfo.compare);
			keyFrame.fixed = true;
			this.frameLength = frameLength;
			trace("skin["+skinName+"]: キーフレーム総数 "+keyFrame.length);
		}

		private function searchRange(start:int, end:int, frameNo:int):int
		{
			if (keyFrame[start].frameNo == frameNo || end == start + 1) return start;
			var n:int = (start + end) / 2;
			if (frameNo < keyFrame[n].frameNo) return searchRange(start, n, frameNo);
			return searchRange(n, end, frameNo);
		}

		public function getSkinParam(frameNo: int):Number
		{
			var n:int = keyFrame.length - 1;
			var kf:KeyFrameInfo = keyFrame[n];
			if (kf.frameNo > frameNo) kf = keyFrame[searchRange(0, n, frameNo)];
			return kf.weight;
		}
	}
}

class KeyFrameInfo
{
	public var frameNo:int;
	public var weight:Number;

	public function KeyFrameInfo(frameNo:int, weight:Number):void
	{
		this.frameNo = frameNo;
		this.weight = weight;
	}
	
	public static function compare(a:KeyFrameInfo, b:KeyFrameInfo):Number
	{
		return (a.frameNo == b.frameNo) ? 0 : (a.frameNo < b.frameNo) ? -1 : 1;
	}
}