﻿package vocaloplus.core
{
	import jp.seagirl.genius.core.WindowedApplication;
	import jp.seagirl.genius.managers.ApplicationManager;
	import mx.events.ModuleEvent;
	import mx.logging.Log;
	import mx.logging.LogEventLevel;
	import mx.logging.targets.TraceTarget;
	
	import mx.events.FlexEvent;
	
	import org.libspark.thread.EnterFrameThreadExecutor;
	import org.libspark.thread.Thread;
	
	import vocaloplus.views.Main;
	import vocaloplus.controllers.ModuleController;

	/**
	 * アプリケーションのメインクラスです。
	 * 原則的に、このクラスは変更しないでください。
	 */
	public class Application extends jp.seagirl.genius.core.WindowedApplication
	{
		public static const APPLICATION_NAME:String = 'Application';
		public static const APPLICATION_VERSION:String = '';	
		public static const DEFAULT_PAGE:String = 'Intro';
		
		private var applicationManager:ApplicationManager;
		private var mainView:Main;
		
		private function initializeApplication():void
		{
			applicationManager = ApplicationManager.instance;
			applicationManager.name = APPLICATION_NAME;
			applicationManager.version = APPLICATION_VERSION;
			applicationManager.defaultState.page = DEFAULT_PAGE;
			applicationManager.traceApplicationInformation();
			
			var tt:TraceTarget = new TraceTarget();
			tt.includeDate = true;
			tt.includeTime = true;
			tt.includeLevel = true;
			tt.includeCategory = true;
			tt.level = LogEventLevel.DEBUG;
			Log.addTarget(tt);
			
			Thread.initialize(new EnterFrameThreadExecutor());
		}
		
		private function initializeView():void
		{
			mainView = new Main();
			addChild(mainView);
			mainView.percentHeight = 100;
			mainView.percentWidth = 100;
		}
		
		override protected function initializeHandler(event:FlexEvent):void
		{	
			initializeApplication();
			initializeView();
		}
		
	}
}