﻿package vocaloplus.views
{
	import flash.display.*;
	import flash.events.*;
	import jp.seagirl.genius.views.*;
	import mx.containers.*;
	import mx.controls.*;
	import mx.core.*;
	import mx.events.*;
	import net.hires.debug.*;
	import org.b2ox.pv3d.*;
	import org.libspark.thread.threads.utils.FunctionThread;
	import org.libspark.thread.utils.*;
	import vocaloplus.controllers.*;
	import vocaloplus.threads.*;
	import vocaloplus.utils.*;

	public class IntroBase extends ViewBase
	{
		//[Embed(source = '../../assets/image/vocaloplus.png')] public var logoCls:Class;
		// Flex4でSVGを扱う場合は Show Deprecation Warningsをfalseにしておく必要有り。将来的にはSVGからFXGに移行しろってことらしい。
		[Embed(source = '../../assets/image/vocaloplus.svg')][Bindable] public var logoSvgCls:Class;

		override protected function initializeView():void
		{
			// ここに初期化処理を記述します。
			// このビューが生成された時にのみ実行されます。
			
			/* TODO これはテストです！　Seacolor 2010/03/13 */
			var soundLogo:LoadSoundThread = ModuleController.makeSoundLoader("vocaloplus_eyecatch");
			var sx:SerialExecutor = new SerialExecutor();
			sx.addThread( soundLogo );
			sx.addThread( soundLogo.player );
			sx.start();

			/* TODO PMDViewerをとりあえず載せてみました。無理矢理過ぎてよくないと思います(^^; b2ox 2010/04/21 */
			var pmdViewer:PMDViewer = new PMDViewer();
			var uiBase:UIComponent = new UIComponent();
			addChild(uiBase);
			uiBase.addChild(pmdViewer);
			initPMDViewer(pmdViewer);
			
			var hbox:Box = new Box();
			hbox.direction = "horizontal";

			// ロゴ画像の貼り付け
			//var logo:Bitmap = new logoCls();
			var logo:Sprite = new logoSvgCls();
			logo.scaleX = 0.09;
			logo.scaleY = 0.09;
			var tmp:UIComponent = new UIComponent();
			tmp.addChild(logo);
			tmp.width = logo.width;
			hbox.addChild(tmp);

			var btnPlay:Button = new Button();
			btnPlay.label = "再生";
			btnPlay.addEventListener(MouseEvent.CLICK, function (evt:MouseEvent):void { pmdViewer.play(); } );
			hbox.addChild(btnPlay);

			var btnStop:Button = new Button();
			btnStop.label = "停止";
			btnStop.addEventListener(MouseEvent.CLICK, function (evt:MouseEvent):void { pmdViewer.stop(); } );
			hbox.addChild(btnStop);

			var btnMotion:Button = new Button();
			btnMotion.label = "モーション変更";
			btnMotion.addEventListener(MouseEvent.CLICK, function (evt:MouseEvent):void { pmdViewer.toggleMotion(); } );
			hbox.addChild(btnMotion);

			addChild(hbox);
		}
		
		private function initPMDViewer(pmdViewer:PMDViewer):void
		{
			// FPSなどの表示
			var stat:Stats = new Stats();
			stat.y = 30;
			pmdViewer.addChild(stat);

			var sx:SerialExecutor = new SerialExecutor();

			// モデルモジュールの読み込み
			var mdl:LoadModelThread = ModuleController.makeModelLoader("Miku_Nanoha1052");
			var miku:MikuMikuDance;
			sx.addThread( mdl );
			sx.addThread( new FunctionThread( function ():void {
				if (mdl == null) throw Error("モデルモジュールの読み込み不良");
				var mmd:MikuMikuDance = ModelTranslator.toMikuMikuDance(mdl.module, 15);
				mmd.y = -150;
				mmd.looping = true;
				pmdViewer.addMMD( mmd );
				var px:ParallelExecutor = new ParallelExecutor();
				px.addThread(loadMotion("Popipo", mmd));
				px.addThread(loadMotion("WiM", mmd));
				px.start();
				px.join();
			} ));
			sx.start();
		}

		private function loadMotion(motionName:String, mmd:MikuMikuDance):SerialExecutor
		{
			var sx:SerialExecutor = new SerialExecutor();
			var mtn:LoadMotionThread = ModuleController.makeMotionLoader(motionName);
			sx.addThread( mtn );
			sx.addThread( new FunctionThread( function():void {
				if (mtn == null) throw Error("モーションモジュールの読み込み不良");
				MotionTranslator.attachMotion(mmd, mtn.module);
			} ));
			return sx;
		}

		override protected function updateView():void
		{
			// ここに画面更新処理を記述します。
			// このビューが表示されると毎回実行されます。
		}
		
	}
}

