unit Unit3;

interface

uses
  System.SysUtils, System.Types, System.UITypes, System.Classes,
  System.Variants,
  FMX.Types, FMX.Controls, FMX.Forms, FMX.Graphics, FMX.Dialogs, FMX.StdCtrls,
  FMX.Media, Data.Bind.EngExt, FMX.Bind.DBEngExt, System.Rtti,
  System.Bindings.Outputs, FMX.Bind.Editors, Data.Bind.Components, FMX.StdActns,
  Math, FMX.Ani;

type
  TForm3 = class(TForm)
    Button1: TButton;
    Button2: TButton;
    Button3: TButton;
    TrackBar1: TTrackBar;
    Switch1: TSwitch;
    SpeedButton1: TSpeedButton;
    Label1: TLabel;
    OpenDialog1: TOpenDialog;
    MediaPlayer1: TMediaPlayer;
    Panel1: TPanel;
    ArcDial1: TArcDial;
    CheckBox1: TCheckBox;
    Label2: TLabel;
    Button4: TButton;
    Timer1: TTimer;
    procedure Button3Click(Sender: TObject);
    procedure SpeedButton1Click(Sender: TObject);
    procedure FormShow(Sender: TObject);
    procedure FormHide(Sender: TObject);
    procedure ArcDial1Change(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure Button4Click(Sender: TObject);
    procedure Timer1Timer(Sender: TObject);
  private
    { private 錾 }
  public
    FileName: string;
    Vol: Single;
    { public 錾 }
  end;

var
  Form3: TForm3;

implementation

{$R *.fmx}

procedure TForm3.ArcDial1Change(Sender: TObject);
begin
  with ArcDial1 do
    if Value > ValueRange.Max then
      Value := ValueRange.Max
    else if Value < ValueRange.Min then
      Value := ValueRange.Min;
  MediaPlayer1.Volume := 1 - ArcDial1.ValueRange.RelativeValue + Vol;
end;

procedure TForm3.Button3Click(Sender: TObject);
begin
  if OpenDialog1.Execute = true then
  begin
    FileName := OpenDialog1.FileName;
    MediaPlayer1.FileName := OpenDialog1.FileName;
    TrackBar1.Max := MediaPlayer1.Duration / MediaTimeScale;
    Label2.Text := TimeToStr(TrackBar1.Max);
    SpeedButton1Click(Sender);
  end;
end;

procedure TForm3.Button4Click(Sender: TObject);
begin
  TrackBar1.Value := 0;
  MediaPlayer1.CurrentTime:=0;
end;

procedure TForm3.FormCreate(Sender: TObject);
begin
  with ArcDial1.ValueRange do
  begin
    Max := 180;
    Min := -120;
    ArcDial1.Value := Min;
    Vol := RelativeValue;
  end;
  Label2.Text := TimeToStr(0);
end;

procedure TForm3.FormHide(Sender: TObject);
begin
  MediaPlayer1.Clear;
  SpeedButton1.IsPressed := false;
end;

procedure TForm3.FormShow(Sender: TObject);
begin
  if FileName <> '' then
    MediaPlayer1.FileName := FileName;
end;

procedure TForm3.SpeedButton1Click(Sender: TObject);
begin
  if SpeedButton1.IsPressed = true then
    MediaPlayer1.Play
  else
    MediaPlayer1.Stop;
  Timer1.Enabled := SpeedButton1.IsPressed;
end;

procedure TForm3.Timer1Timer(Sender: TObject);
begin
  TrackBar1.Value := MediaPlayer1.CurrentTime / MediaTimeScale;
end;

end.
