/*
  compatible functions

  Copyright (C) 2005 Video maid project. (http://vmaid.sourceforge.jp)

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*/

/* ja: 忠実な互換性はありません。 */

#ifndef __COMPATIBLE_H__
#define __COMPATIBLE_H__


#include "huffyuv.h"


#ifdef __cplusplus
extern "C" {
#endif


UINT compat_GetPrivateProfileInt(LPCTSTR lpAppName,
                                 LPCTSTR lpKeyName,
                                 INT nDefault,
                                 LPCTSTR lpFileName);
#define GetPrivateProfileInt compat_GetPrivateProfileInt
BOOL compat_WritePrivateProfileString(LPCTSTR lpAppName,
                                      LPCTSTR lpKeyName,
                                      LPCTSTR lpString,
                                      LPCTSTR lpFileName);  /* XXX: */
#define WritePrivateProfileString compat_WritePrivateProfileString

void compat_About(void);
void compat_Configure(struct MethodName *yuv_method_names,
                      struct MethodName *rgb_method_names);

void compat_wvsprintf(LPTSTR lpOutput, LPCTSTR lpFmt, va_list arglist);
#define wvsprintf compat_wvsprintf

void compat_WriteConsole(const VOID* lpBuffer);
void compat_MultiByteToWideChar(LPWSTR dst, LPCSTR src);

int compat_wsprintfA(LPTSTR lpOut, LPCTSTR lpFmt, ...);
#define wsprintfA compat_wsprintfA
int compat_lstrlen(LPCTSTR lpString);
#define lstrlen compat_lstrlen
LPTSTR compat_lstrcpy(LPTSTR lpString1, LPCTSTR lpString2);
#define lstrcpy compat_lstrcpy

LRESULT compat_DefDriverProc(DWORD dwDriverId, HDRVR hdrvr,
                             UINT msg, LPARAM lParam1, LPARAM lParam2);
#define DefDriverProc compat_DefDriverProc


#ifdef __cplusplus
}
#endif


#endif /* __COMPATIBLE_H__ */
