/*
  compatible define

  Copyright (C) 2005 Video maid project. (http://vmaid.sourceforge.jp)

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*/


#ifndef __COMPATDEF_H__
#define __COMPATDEF_H__


#ifdef __cplusplus
extern "C" {
#endif


/*
 * depend
 */


/* huffyuv.h */

typedef unsigned long DWORD;  /* windef.h */
typedef unsigned char BYTE;  /* windef.h */
typedef unsigned short WORD;  /* windef.h */
#define MAKEFOURCC(c0,c1,c2,c3) ((DWORD)(BYTE)(c0)|((DWORD)(BYTE)(c1)<<8)|((DWORD)(BYTE)(c2)<<16)|((DWORD)(BYTE)(c3)<<24))  /* mmsystem.h */
typedef void *PVOID;  /* winnt.h */
typedef PVOID HANDLE;  /* winnt.h */
#define DECLARE_HANDLE(n) typedef HANDLE n  /* winnt.h */
DECLARE_HANDLE(HWND);  /* windef.h */
#if 0
typedef unsigned short wchar_t;  /* winnt.h */
typedef wchar_t WCHAR;  /* winnt.h */
#else
typedef unsigned short ____wchar_t;
typedef ____wchar_t WCHAR;
#endif
typedef long LONG;  /* winnt.h */
typedef void *LPVOID;  /* winnt.h */
typedef DWORD *LPDWORD;  /* windef.h */
#if defined(_WIN64)
typedef __int64 LONG_PTR;
#else
typedef long LONG_PTR;
#endif  /* basetsd.h */
typedef LONG_PTR LRESULT;  /* windef.h */
typedef char CHAR; /* winnt.h */
typedef short SHORT; /* winnt.h */
#ifdef UNICODE
typedef WCHAR TCHAR;
#else
typedef CHAR TCHAR;
#endif /* winnt.h */


/* huffyuv.cpp */

#ifdef UNICODE
#define __TEXT(q) L##q
#else
#define __TEXT(q) q
#endif /* winnt.h */
typedef int WINBOOL;  /* windef.h */


/* drvproc.cpp */

#define __stdcall  /* XXX: */
#define _pascal __stdcall  /* windef.h */
#define DRVCNF_OK 1  /* vfw.h */
#define DRV_USER 0x4000  /* mmsystem.h */
#define	ICM_RESERVED_LOW	(DRV_USER+0x1000)  /* vfw.h */
#define	ICM_RESERVED	ICM_RESERVED_LOW  /* vfw.h */
#define	ICM_USER	(DRV_USER+0x0000)  /* vfw.h */


/* 
 * huffyuv.h
 */

//DWORD
#define mmioFOURCC(c0,c1,c2,c3) MAKEFOURCC(c0,c1,c2,c3) /* mmsystem.h */
//HWND
//LPVOID
typedef struct {
	DWORD dwSize;
	DWORD fccType;
	DWORD fccHandler;
	DWORD dwFlags;
	DWORD dwVersion;
	DWORD dwVersionICM;
	WCHAR szName[16];
	WCHAR szDescription[128];
	WCHAR szDriver[128];
} ICINFO; /* vfw.h */
typedef struct tagBITMAPINFOHEADER{
	DWORD	biSize;
	LONG	biWidth;
	LONG	biHeight;
	WORD	biPlanes;
	WORD	biBitCount;
	DWORD	biCompression;
	DWORD	biSizeImage;
	LONG	biXPelsPerMeter;
	LONG	biYPelsPerMeter;
	DWORD	biClrUsed;
	DWORD	biClrImportant;
} BITMAPINFOHEADER, *LPBITMAPINFOHEADER;  /* wingdi.h */
typedef struct {
	DWORD dwFlags;
	LPBITMAPINFOHEADER lpbiOutput;
	LPVOID lpOutput;
	LPBITMAPINFOHEADER lpbiInput;
	LPVOID lpInput;
	LPDWORD lpckid;
	LPDWORD lpdwFlags;
	LONG lFrameNum;
	DWORD dwFrameSize;
	DWORD dwQuality;
	LPBITMAPINFOHEADER lpbiPrev;
	LPVOID lpPrev;
} ICCOMPRESS; /* vfw.h */
typedef struct {
	DWORD dwFlags;
	LPBITMAPINFOHEADER lpbiInput;
	LPVOID lpInput;
	LPBITMAPINFOHEADER lpbiOutput;
	LPVOID lpOutput;
	DWORD ckid;
} ICDECOMPRESS; /* vfw.h */
typedef struct {
	DWORD dwSize;
	DWORD fccType;
	DWORD fccHandler;
	DWORD dwVersion;
	DWORD dwFlags;
	LRESULT dwError;
	LPVOID pV1Reserved;
	LPVOID pV2Reserved;
	DWORD dnDevNode;
} ICOPEN; /* vfw.h */


/* 
 * huffyuv.cpp
 */

#define TEXT(q) __TEXT(q)  /* winnt.h */
#define ICTYPE_VIDEO	mmioFOURCC('v','i','d','c')  /* vfw.h */
#ifndef NULL
#ifdef __cplusplus
#define NULL 0
#else
#define NULL ((void*)0)
#endif
#endif  /* windef.h */
#define	ICERR_OK	0  /* vfw.h */
#define	ICERR_MEMORY	-3  /* vfw.h */
//BITMAPINFOHEADER
//LPBITMAPINFOHEADER
typedef WINBOOL BOOL;  /* windef.h */
#ifndef TRUE
#define TRUE 1
#endif  /* windef.h */
//HWND
#define ICVERSION 0x0104  /* vfw.h */
#define	ICERR_BADFORMAT	-2  /* vfw.h */
#ifndef __int32
#define __int32 long
#endif  /* basetyps.h */
#ifndef max
#define max(a,b) ((a)>(b)?(a):(b))
#endif  /* windef.h */
#define AVIIF_KEYFRAME	0x10  /* vfw.h */


/*
 * drvproc.cpp
 */

//LRESULT
#define PASCAL _pascal  /* windef.h */
DECLARE_HANDLE(HDRVR);  /* mmsystem.h */
typedef unsigned int UINT;  /* windef.h */
typedef LONG_PTR LPARAM;  /* windef.h */
#define DRV_LOAD  0x0001  /* mmsystem.h */
#define DRV_FREE  0x0006  /* mmsystem.h */
#define DRV_OPEN  0x0003  /* mmsystem.h */
#define DRV_CLOSE 0x0004  /* mmsystem.h */
#define DRV_QUERYCONFIGURE  0x0008  /* mmsystem.h */
#define DRV_CONFIGURE  0x0007  /* mmsystem.h */
#define DRV_OK DRVCNF_OK  /* mmsystem.h */
#define	ICM_CONFIGURE	(ICM_RESERVED+10)  /* vfw.h */
#define	ICM_ABOUT	(ICM_RESERVED+11)  /* vfw.h */
#define	ICERR_UNSUPPORTED	-1  /* vfw.h */
#define	ICERR_ABORT	-10  /* vfw.h */
#define	ICM_GETSTATE	(ICM_RESERVED+0)  /* vfw.h */
#define	ICM_SETSTATE	(ICM_RESERVED+1)  /* vfw.h */
#define	ICM_GETINFO	(ICM_RESERVED+2)  /* vfw.h */
#define	ICM_GETDEFAULTQUALITY	(ICM_RESERVED+30)  /* vfw.h */
//LPDWORD
#define	ICM_COMPRESS_QUERY	(ICM_USER+6)  /* vfw.h */
#define	ICM_COMPRESS_BEGIN	(ICM_USER+7)  /* vfw.h */
#define	ICM_COMPRESS_GET_FORMAT	(ICM_USER+4)  /* vfw.h */
#define	ICM_COMPRESS_GET_SIZE	(ICM_USER+5)  /* vfw.h */
#define	ICM_COMPRESS	(ICM_USER+8)  /* vfw.h */
#define	ICM_COMPRESS_END	(ICM_USER+9)  /* vfw.h */
#define	ICM_DECOMPRESS_QUERY	(ICM_USER+11)  /* vfw.h */
#define	ICM_DECOMPRESS_BEGIN	(ICM_USER+12)  /* vfw.h */
#define	ICM_DECOMPRESS_GET_FORMAT	(ICM_USER+10)  /* vfw.h */
#define	ICM_DECOMPRESS_GET_PALETTE	(ICM_USER+30)  /* vfw.h */
#define	ICM_DECOMPRESS	(ICM_USER+13)  /* vfw.h */
#define	ICM_DECOMPRESS_END	(ICM_USER+14)  /* vfw.h */
#define DRV_DISABLE 5  /* mmsystem.h */
#define DRV_ENABLE 2  /* mmsystem.h */
#define DRV_INSTALL 9  /* mmsystem.h */
#define DRV_REMOVE 10  /* mmsystem.h */
//DRV_USER


/* 
 * compatible.c
 */

typedef const TCHAR *LPCTSTR;  /* winnt.h */
typedef int INT;  /* windef.h */
#ifndef CONST
#define CONST const
#endif  /* windef.h */
typedef CONST CHAR *LPCSTR;  /* winnt.h */
typedef TCHAR *LPTSTR;  /* winnt.h */
#ifndef VOID
#define VOID void
#endif  /* winnt.h */
typedef WCHAR *LPWSTR;  /* winnt.h */


#ifdef __cplusplus
}
#endif


#endif /* __COMPATDEF_H__ */
