package gnu.vnc.awt;

import gnu.vnc.*;
import gnu.awt.virtual.*;
import gnu.rfb.*;
import gnu.rfb.server.*;

import java.io.*;
import java.awt.*;
import java.awt.image.*;

/**
* A {@link gnu.awt.virtual.VirtualFrame virtual AWT frame} that supports multiple RFB clients.
**/

@SuppressWarnings("serial")
public class VNCFrame extends VirtualFrame implements RFBServer
{
	//
	// Construction
	//
	
	public VNCFrame( Toolkit toolkit, String name, int width, int height )
	{
		super( toolkit, name );
		
		events = new VNCEvents( this, clients );
		queue = new VNCQueue( clients );
		
		// VNC frames cannot change size
		setSize( width, height );
		super.setResizable( false );

		setVisible(true); //show();
	}
	
	//
	// Frame
	//
	
	@Override
	public void dispose()
	{
		clients.closeAll();
		super.dispose();
	}
	
	//
	// RFBServer
	//

	// Clients
	
	public void addClient( RFBClient client )
	{
		clients.addClient( client );
	}
	
	public void removeClient( RFBClient client )
	{
		clients.removeClient( client );
		if( clients.isEmpty() && !shared )
			dispose();
	}
	
	// Attributes
	
	public String getDesktopName( RFBClient client )
	{
		return getTitle();
	}
	
	public int getFrameBufferWidth( RFBClient client )
	{
		Insets insets = getInsets();
		return getWidth() - insets.left - insets.right;
	}
	
	public int getFrameBufferHeight( RFBClient client )
	{
		Insets insets = getInsets();
		return getHeight() - insets.top - insets.bottom;
	}
	
	public PixelFormat getPreferredPixelFormat( RFBClient client )
	{
		return PixelFormat.RGB888;
	}
	
	public boolean allowShared()
	{
		return true;
	}
	
	// Messages from client to server

	public void setClientProtocolVersionMsg( RFBClient client, String protocolVersionMsg ) throws IOException
	{
	}
	
	public void setShared( RFBClient client, boolean shared ) throws IOException
	{
		if( shared )
			this.shared = true;
	}
	
	public void setPixelFormat( RFBClient client, PixelFormat pixelFormat ) throws IOException
	{
		pixelFormat.setDirectColorModel( (DirectColorModel) getToolkit().getColorModel() );
	}
	
	public void setEncodings( RFBClient client, int[] encodings ) throws IOException
	{
	}
	
	public void fixColourMapEntries( RFBClient client, int firstColour, Colour[] colourMap ) throws IOException
	{
	}
	
	public void frameBufferUpdateRequest( RFBClient client, boolean incremental, int x, int y, int w, int h ) throws IOException
	{
		queue.frameBufferUpdate( client, incremental, x, y, w, h, this );
	}
	
	public void keyEvent( RFBClient client, boolean down, int key ) throws IOException
	{
		events.translateKeyEvent( client, down, key );
	}
	
	public void pointerEvent( RFBClient client, int buttonMask, int x, int y ) throws IOException
	{
		events.translatePointerEvent( client, buttonMask, x, y );
	}
	
	public void clientCutText( RFBClient client, String text ) throws IOException
	{
	}

	///////////////////////////////////////////////////////////////////////////////////////
	// Private
	
	private RFBClients clients = new RFBClients();
	private VNCEvents events;
	private boolean shared = false;
	protected VNCQueue queue;
}

