package gnu.awt.virtual.swing;

import java.awt.*;
import java.awt.peer.*;
import java.awt.BufferCapabilities.FlipContents;
import java.awt.event.*;
import java.beans.*;

import javax.swing.*;

import sun.awt.CausedFocusEvent.Cause;
import sun.java2d.pipe.Region;

/**
* AWT frame peer implemented as a {@link javax.swing.JInternalFrame}.
**/

@SuppressWarnings("serial")
class SwingFramePeer extends JInternalFrame implements FramePeer
{
	//
	// Static operations
	//

	public static void add( Component component, Component peer )
	{
		SwingFramePeer framePeer = getFramePeer( component );
		if( framePeer != null )
			framePeer.getContentPane().add( peer );
	}
	
	//
	// Construction
	//
	
	public SwingFramePeer( JDesktopPane desktopPane, Frame frame )
	{
		super();
		desktopPane.add( this );
	
		setLocation( frame.getLocation() );
		setSize( frame.getSize() );
		setResizable( frame.isResizable() );
		setIconifiable( true );
		setMaximizable( true );
		setClosable( true );
		try
		{
			setIcon( frame.getState() == Frame.ICONIFIED );
		}
		catch( PropertyVetoException x )
		{
		}
		setState( frame.getState() );
		setTitle( frame.getTitle() );
		setIconImage( frame.getIconImage() );
		setMenuBar( frame.getMenuBar() );
	}
	
	//
	// FramePeer
	//

	public void setIconImage( Image im )
	{
	}
	
	public void setMenuBar( MenuBar mb )
	{
	}
	
	public void setState( int state )
	{
		if ( state == Frame.ICONIFIED )
		{
		}
		else // state == Frame.NORMAL
		{
		}
	}
	
	public int getState()
	{
		return -1;
	}
	
	public void setMaximizedBounds( java.awt.Rectangle bounds )
	{
	}
	
	//
	// WindowPeer
	//

	public int handleFocusTraversalEvent( KeyEvent e )
	{
		return -1;
	}
	
	//
	// ContainerPeer
	//

	public void beginValidate()
	{
	}
	
	public void endValidate()
	{
	}
	
	public void beginLayout()
	{
	}
	
	public void endLayout()
	{
	}
	
	public boolean isPaintPending()
	{
		return false;
	}

	//
	// ComponentPeer
	//
	
	// Events
	
	public void handleEvent( AWTEvent e )
	{
		//System.err.println(e);
	}
	
	public void coalescePaintEvent( PaintEvent e )
	{
		System.err.println(e);
	}
	
	public boolean handlesWheelScrolling()
	{
		return false;
	}
	
	// Obscurity
	
	public boolean isObscured()
	{
		return false;
	}
	
	public boolean canDetermineObscurity()
	{
		return false;
	}
	
	// Focus
	
	public boolean requestFocus( Component lightweightChild, boolean temporary, boolean focusedWindowChangeAllowed, long time )
	{
		return true;
	}
	
	// Buffer
	
	public void createBuffers( int x, BufferCapabilities bufferCapabilities )
	{
	}
	
	public void destroyBuffers()
	{
	}
	
	public void flip( BufferCapabilities.FlipContents flipContents )
	{
	}
	
	public Image getBackBuffer()
	{
		return null;
	}
	
	// Cursor
	
	public void updateCursorImmediately()
	{
	}
	
	// Misc
	
	public void dispose()
	{
	}
	
	///////////////////////////////////////////////////////////////////////////////////////
	// Private

	private static SwingFramePeer getFramePeer( Component component )
	{
		Component parent = component.getParent();
		if( parent == null )
		{
			return null;
		}
		else
		{
			ComponentPeer parentPeer = parent.getPeer();
			if( parentPeer instanceof SwingFramePeer )
				return (SwingFramePeer) parentPeer;
			else
				return getFramePeer( parent );	
		}
	}

	public Rectangle getBoundsPrivate() {
		// TODO Auto-generated method stub
		return null;
	}

	public void setBoundsPrivate(int arg0, int arg1, int arg2, int arg3) {
		// TODO Auto-generated method stub
		
	}

	public void repositionSecurityWarning() {
		// TODO Auto-generated method stub
		
	}

	public boolean requestWindowFocus() {
		// TODO Auto-generated method stub
		return false;
	}

	public void setAlwaysOnTop(boolean arg0) {
		// TODO Auto-generated method stub
		
	}

	public void setModalBlocked(Dialog arg0, boolean arg1) {
		// TODO Auto-generated method stub
		
	}

	public void setOpacity(float arg0) {
		// TODO Auto-generated method stub
		
	}

	public void updateFocusableWindowState() {
		// TODO Auto-generated method stub
		
	}

	public void updateIconImages() {
		// TODO Auto-generated method stub
		
	}

	public void updateMinimumSize() {
		// TODO Auto-generated method stub
		
	}

	public void updateWindow() {
		// TODO Auto-generated method stub
		
	}

	public boolean isRestackSupported() {
		// TODO Auto-generated method stub
		return false;
	}

	public void restack() {
		// TODO Auto-generated method stub
		
	}

	public void applyShape(Region arg0) {
		// TODO Auto-generated method stub
		
	}

	public void flip(int arg0, int arg1, int arg2, int arg3, FlipContents arg4) {
		// TODO Auto-generated method stub
		
	}

	public boolean isReparentSupported() {
		// TODO Auto-generated method stub
		return false;
	}

	public void reparent(ContainerPeer arg0) {
		// TODO Auto-generated method stub
		
	}

	public boolean requestFocus(Component arg0, boolean arg1, boolean arg2,
			long arg3, Cause arg4) {
		// TODO Auto-generated method stub
		return false;
	}

	public void setBounds(int arg0, int arg1, int arg2, int arg3, int arg4) {
		// TODO Auto-generated method stub
		
	}
}
