#include "UndoMgr.h"
#include "Scene.h"
#include "Node.h"
#include <QDebug>

UndoMgr::UndoMgr(QObject *parent)
	: QUndoStack(parent)
{

}

UndoMgr::~UndoMgr()
{

}

//----------------------------------------------------------------------
UndoDeleteNodeCommand::UndoDeleteNodeCommand(
							Scene *scene,
							Node *node)
	: QUndoCommand(0)
	, m_scene(scene)
	, m_node(node)
	//, m_parentNode(node->parentNode())
	, m_index(node->parentNode() ? node->parentNode()->childIndexOf(node) : -1)
{
}
void UndoDeleteNodeCommand::undo()
{
	if( m_node->parentNode() ) {
		Node *pNode = m_node->parentNode();
		pNode->insert(m_index, m_node);
		if( !pNode->isVisible() ) {			//	em[h܂܂Ăꍇ
			while( !pNode->isVisible() )
				pNode = pNode->parentNode();
			m_scene->doCollapseExpand(pNode);
		}
	} else
		m_scene->addToFloatingNodes(m_node);
	m_node->addToScene(m_scene);
	m_scene->setSelectedNode(m_node);
	m_scene->layoutAll();
}
void UndoDeleteNodeCommand::redo()
{
	m_scene->removeNode(m_node);
	m_scene->layoutAll();
}
#if 0
//----------------------------------------------------------------------
UndoAddParentNodeCommand::UndoAddParentNodeCommand(Scene *scene,
								Node *node,		//	e쐬m[h
								int index)
	: QUndoCommand(0)
	, m_scene(scene)
	, m_parentNode(0)
	, m_node(node)
	, m_index(index)
{
}
void UndoAddParentNodeCommand::undo()
{
	//	m_parentNode	쐬ꂽm[h̐em[h
	//	m_node	쐬ꂽm[h
	//	m_node ̎q͂ЂƂ̂͂
	Node *ptr = m_node->firstChildNode();
	m_parentNode->insert(m_ix, ptr);
	m_scene->removeNode(m_node);
	m_scene->setSelectedNode(ptr);
	m_scene->layoutAll();
}
void UndoAddParentNodeCommand::redo()
{
	if( !m_parentNode ) {		//	ŏ redo ̏ꍇ
		m_parentNode = m_node->parentNode();
		Node *ptr = m_node;	//	ŏ redo Fm_node ͐e쐬m[h|CgĂ
		m_ix = m_parentNode->childIndexOf(ptr);

	} else {
	}
	Node *pNode = m_node->parentNode();
	pNode->insert(m_index, m_node);
	m_node->addToScene(m_scene);
	//m_scene->clearSelection();
	m_scene->setSelectedNode(m_node);
	m_scene->layoutAll();
}
#endif
//----------------------------------------------------------------------
UndoAddNodeCommand::UndoAddNodeCommand(Scene *scene, Node *node, int index)
	: QUndoCommand(0)
	, m_scene(scene)
	, m_node(node)
	, m_index(index)
{
}
void UndoAddNodeCommand::undo()
{
	m_scene->removeNode(m_node);
	m_scene->layoutAll();
}
void UndoAddNodeCommand::redo()
{
	Node *pNode = m_node->parentNode();
	if( pNode ) {
		pNode->insert(m_index, m_node);
	} else
		m_scene->addToFloatingNodes(m_node);
	m_node->setModifiedDT();
	//m_scene->clearSelection();
	m_node->addToScene(m_scene);
	m_scene->setSelectedNode(m_node);
#if 0
	QList<QGraphicsItem *> list = m_scene->selectedItems();
	qDebug() << list.size();
	qDebug() << list;
#endif
	m_scene->layoutAll();
}
//----------------------------------------------------------------------
UndoMoveNodeUpCommand::UndoMoveNodeUpCommand(Scene *scene, Node *node)
	: QUndoCommand(0)
	, m_scene(scene)
	, m_node(node)
{
}
void UndoMoveNodeUpCommand::undo()
{
	m_scene->setSelectedNode(m_node);
	m_scene->doMoveNodeDown();
}
void UndoMoveNodeUpCommand::redo()
{
	m_scene->setSelectedNode(m_node);
	m_scene->doMoveNodeUp();
}
//----------------------------------------------------------------------
UndoMoveNodeDownCommand::UndoMoveNodeDownCommand(Scene *scene, Node *node)
	: QUndoCommand(0)
	, m_scene(scene)
	, m_node(node)
{
}
void UndoMoveNodeDownCommand::undo()
{
	m_scene->setSelectedNode(m_node);
	m_scene->doMoveNodeUp();
}
void UndoMoveNodeDownCommand::redo()
{
	m_scene->setSelectedNode(m_node);
	m_scene->doMoveNodeDown();
}
//----------------------------------------------------------------------
UndoMoveNodeCommand::UndoMoveNodeCommand(Scene *scene, Node *node,
											Node *sp, bool sr, int si,
											Node *dp, bool dr, int di)
	: QUndoCommand(0)
	, m_scene(scene)
	, m_node(node)
	, m_srcPN(sp)
	, m_srcIsRS(sr)
	, m_srcIx(si)
	, m_dstPN(dp)
	, m_dstIsRS(sr)
	, m_dstIx(di)
{
}
void UndoMoveNodeCommand::undo()
{
	m_dstPN->removeFromChildrenList(m_node);
	m_srcPN->insert(m_srcIx, m_node);
	m_node->setRightSideRecursive(m_srcIsRS);
	m_node->updateLinkIconPosRecursive();
	m_scene->setSelectedNode(m_node);
	m_scene->layoutAll();
	m_node->ensureVisible();
}
void UndoMoveNodeCommand::redo()
{
	if( m_dstIx < 0 ) {		//	push()  redo() ͏sȂ悤
		m_dstIx = m_dstPN->childIndexOf(m_node);
		m_dstIsRS = m_node->isRightSide();
	} else {
		m_srcPN->removeFromChildrenList(m_node);
		m_dstPN->insert(m_dstIx, m_node);
		m_scene->setSelectedNode(m_node);
	}
	m_node->setRightSideRecursive(m_dstIsRS);
	m_node->updateLinkIconPosRecursive();
	m_node->setModifiedDT();
	m_scene->layoutAll();
	m_node->ensureVisible();
}
//----------------------------------------------------------------------
UndoLinkNodeCommand::UndoLinkNodeCommand(Scene *scene, Node *node, const QString &linkText)
	: QUndoCommand(0)
	, m_scene(scene)
	, m_node(node)
	, m_linkText(linkText)
{
}
void UndoLinkNodeCommand::undoRedo()
{
	QString tmp = m_node->linkedFileName();
	m_node->setLink(m_linkText);
	m_linkText = tmp;
	m_scene->setSelectedNode(m_node);
	m_scene->layoutAll();
}
//----------------------------------------------------------------------
void UndoColorNodeCommand::undoRedo()
{
	QColor col = m_node->fillColor();
	m_node->setFillColor(m_color);
	m_color = col;
	m_scene->setSelectedNode(m_node);
	m_scene->layoutAll();
}
//----------------------------------------------------------------------
void UndoFontNodeCommand::undoRedo()
{
	QFont font = m_node->font();
	m_node->setTextWidth(-1);
	m_node->setFont(m_font);
	m_node->setTextWidth(m_node->textWidthEx());
	m_node->updateLinkIconPos();
	m_font = font;
	m_scene->setSelectedNode(m_node);
	if( !m_macro )
		m_scene->layoutAll();
}
//----------------------------------------------------------------------
void UndoChangeNodePosCommand::undoRedo()
{
	const QPointF p = m_node->pos();
	m_node->setPos(m_pos);
	m_pos = p;
	m_scene->setSelectedNode(m_node);
	m_scene->layoutAll();		//	for XN[GAAbvf[g
	m_scene->update();
}
//----------------------------------------------------------------------
void UndoEditNodeTextCommand::doUndoRedo()
{
	const QString text = m_node->toPlainText();
	//if( text == m_text )
	//	return;		//	push()  redo() ̏ꍇ
	m_node->setPlainText(m_text);
	m_text = text;
	m_scene->layoutAll();
	m_scene->setSelectedNode(m_node);
	m_node->ensureVisible();
}
