#include <QtGui>
#include "PDView.h"
#include "Scene.h"
#include "Node.h"

//----------------------------------------------------------------------
PDViewNode::~PDViewNode()
{
	foreach(PDViewNode *ptr, m_children)
		delete ptr;
}

//----------------------------------------------------------------------
PDView::PDView(Scene *scene, QWidget *parent)
	: QWidget(parent)
	, m_scene(scene)
	, m_scale(1.0)
	, m_center(QPointF(0, 0))
	//, m_vnRoot(0)
{

}

PDView::~PDView()
{
	//delete m_vnRoot;
}

void PDView::setupViewNode()
{
	//if( m_vnRoot != 0 )
	//	delete *m_vnRoot;
	foreach(PDViewNode *ptr, m_vnRoot.m_children)
		delete ptr;
	m_vnRoot.m_children.clear();
	Node *root = m_scene->rootNode();
	if( !root ) return;
	m_vnRoot.m_pos = PDPos(root);
	foreach(Node *node, root->children()) {
		PDViewNode *vnode = new PDViewNode();
		vnode->m_pos = PDPos(root);
	}
}
void PDView::paintEvent ( QPaintEvent * event )
{
	QPainter painter(this);
	Node *root = m_scene->rootNode();
	if( !root ) return;

	m_center = root->scenePos();
	QPointF pdp = PDPos(root);
	QPointF xy = PDtoXY(pdp);
	foreach(Node *ptr, root->children()) {
		drawBranch(&painter, ptr, xy);
	}
	drawNode(&painter, root, pdp);
	foreach(Node *ptr, root->children()) {
		drawNode(&painter, ptr);
	}
}
void PDView::drawBranch(QPainter *painter, const Node *node, QPointF pxy)
{
	QPointF xy = PDtoXY(PDPos(node));
	painter->drawLine(pxy, xy);
	foreach(Node *ptr, node->children()) {
		drawBranch(painter, ptr, xy);
	}
}
QPointF PDView::PDtoXY(const QPointF &PD)
{
	QRect rct = rect();
	QPoint rctCenter = rct.center();
	int wd2 = rct.width() / 2;
	int ht2 = rct.height() / 2;
	qreal x = rctCenter.x() + PD.x() * wd2;
	qreal y = rctCenter.y() + PD.y() * ht2;
	return QPoint(x, y);
}
void PDView::drawNode(QPainter *painter, const Node *node)
{
	QPointF pdp = PDPos(node);
	drawNode(painter, node, pdp);
	foreach(Node *ptr, node->children()) {
		drawNode(painter, ptr);
	}
}

qreal tanh(qreal x)
{
	const qreal ex = qExp(x);
	const qreal emx = 1 / ex;
	return (ex - emx) / (ex + emx);
}
//	(0, 0) 𒆐SƂAaPPD~̍WlԂ
QPointF PDView::PDPos(const Node *node)
{
	QPointF sp = node->scenePos();
	qreal x = (sp.x() - m_center.x()) / 500.;
	qreal y = (sp.y() - m_center.y()) / 500.;
	qreal r = qSqrt(x * x + y * y);
	qreal theta = qAtan2(y, x);			//	3OCvɉ
	qreal nr = tanh(r);
	return QPointF(nr * qCos(theta), nr * qSin(theta));
}
void PDView::drawNode(QPainter *painter, const Node *node, QPointF pdp)
{
	QRect rct = rect();
	QPoint rctCenter = rct.center();
	int wd2 = rct.width() / 2;
	int ht2 = rct.height() / 2;
	qreal x = rctCenter.x() + pdp.x() * wd2;
	qreal y = rctCenter.y() + pdp.y() * ht2;
	painter->drawEllipse(QRectF(x - 2, y - 2, 4, 4));
	if( node->parentNode() == 0 || node->parentNode()->parentNode() == 0 )
		painter->drawText(x, y, node->toPlainText());
}
