#import "HotkeyCtrl.h"
#import "DummyClass.h"
#import "DirectController.h"
#import "MainController.h"
#import "Recoder.h"


typedef enum{
    power_onoff=0,
    input_pcusb=1,
    input_band=2,
    input_cd=3,
    input_md=4,
    input_tapeaux=5,
    volume_up=6,
    volume_down=7,
    volume_mute=8,
    volume_tone=9,
    input_am=10,
    controller_trig=11,
    menuItem_trig=12,
    hk_through=13,
    hk_record=14
} hotkey_main;


@implementation HotkeyCtrl

-(id)init{
    [super initWithNum:HOTKEY_NUM];
    
    _hotkeyMethod[0]=@selector(powerONOFF);
    _hotkeyMethod[1]=@selector(inputPCUSB);
    _hotkeyMethod[2]=@selector(inputFM);
    _hotkeyMethod[3]=@selector(inputCD);
    _hotkeyMethod[4]=@selector(inputMD);
    _hotkeyMethod[5]=@selector(inputTAPEAUX);
    _hotkeyMethod[6]=@selector(volumeUP);
    _hotkeyMethod[7]=@selector(volumeDOWN);
    _hotkeyMethod[8]=@selector(volumeMUTE);
    _hotkeyMethod[9]=@selector(volumeTONE);
    _hotkeyMethod[10]=@selector(inputAM);
    _hotkeyMethod[11]=@selector(controllerTrig);
    _hotkeyMethod[12]=@selector(menuItemTrig);
    _hotkeyMethod[13]=@selector(throughHotKey);
    _hotkeyMethod[14]=@selector(recordHotKey);
    
    return self;
}

-(void)awakeFromNib{
    _fld[0]=_fld0;
    _fld[1]=_fld1;
    _fld[2]=_fld2;
    _fld[3]=_fld3;
    _fld[4]=_fld4;
    _fld[5]=_fld5;
    _fld[6]=_fld6;
    _fld[7]=_fld7;
    _fld[8]=_fld8;
    _fld[9]=_fld9;
    _fld[10]=_fld10;
    _fld[11]=_fld11;
    _fld[12]=_fld12;
    _fld[13]=fld13_;
    _fld[14]=fld14_;
}

- (void) recordHotKey {
	[recoder_ record];
}

- (void) throughHotKey {
	[recoder_ playThrough];
}

-(void)powerONOFF{
    [_directCtrl power:nil];
}

-(void)inputPCUSB{
    [_directCtrl changeInput:[DummyClass dummyWithTag:usbM]];
}

-(void)inputFM{
    [_directCtrl changeInput:[DummyClass dummyWithTag:fmM]];
}

-(void)inputAM{
    [_directCtrl changeInput:[DummyClass dummyWithTag:amM]];
}

-(void)inputCD{
    [_directCtrl changeInput:[DummyClass dummyWithTag:cdM]];
}

-(void)inputMD{
    [_directCtrl changeInput:[DummyClass dummyWithTag:mdM]];
}

-(void)inputTAPEAUX{
    [_directCtrl changeInput:[DummyClass dummyWithTag:tapeM]];
}

-(void)volumeUP{
    [_directCtrl changeVolume:[DummyClass dummyWithTag:1]];
}

-(void)volumeDOWN{
    [_directCtrl changeVolume:[DummyClass dummyWithTag:-1]];
}

-(void)volumeMUTE{
    [_directCtrl mute:nil];
}

-(void)volumeTONE{
    [_directCtrl tone:nil];
}

-(void)controllerTrig{
    [_directCtrl triggerController:nil];
}

-(void)menuItemTrig{
    [_mainCtrl menuItemTrigger];
}

@end
