//
//  HotkeyItem.h
//  VH7PC_Controller
//
//  Created by nya on 04/10/10.
//  Copyright 2004 __MyCompanyName__. All rights reserved.
//

#import <Cocoa/Cocoa.h>
#import <Carbon/Carbon.h>


enum {
	HOTKEY_TAG_POWER			= 0,
	HOTKEY_TAG_SEL_PCUSB		= 1,
	HOTKEY_TAG_SEL_FM			= 2,
	HOTKEY_TAG_SEL_CD			= 3,
	HOTKEY_TAG_SEL_MD			= 4,
	HOTKEY_TAG_SEL_AUX			= 5,
	HOTKEY_TAG_VOL_UP			= 6,
	HOTKEY_TAG_VOL_DOWN			= 7,
	HOTKEY_TAG_MUTE				= 8,
	HOTKEY_TAG_TONE				= 9,
	HOTKEY_TAG_SEL_AM			= 10,
	HOTKEY_TAG_SHOW_CTRLWIN		= 11,
	HOTKEY_TAG_SHOW_MENU		= 12,

	HOTKEY_TAG_AM_PRESET		= 13,
	HOTKEY_TAG_FM_PRESET		= 14
};


typedef struct{
    unsigned short keyCode;
    NSString *keyStr;
    BOOL shift;
    BOOL command;
    BOOL option;
    BOOL control;
    BOOL sat;
} KeyCombination;

@interface HotkeyItem : NSObject {
    KeyCombination	keycon_;
	EventHotKeyRef	hotkey_;
	SEL				method_;
	
	int				tag_;
}

+ (id) itemWithDictionary:(NSDictionary *)dic;

- (id) initWithDictionary:(NSDictionary *)dic;

- (NSDictionary *) dictionary ;
- (void) setDictionary:(NSDictionary *)dic;

@end
