//
// HotKeyApplication.h
//

#import <Carbon/Carbon.h>
#import <Cocoa/Cocoa.h>
#import "VH7PC.h"

@interface HotkeyApp : NSApplication
{
    IBOutlet id vh7pc;
    IBOutlet id recoder_;
    
    int command;
    int value;
}

//
// Register hot key
//
- (void*)registerHotKeyCode:(unsigned int)keyCode 
                withModifier:(unsigned int)keyModifier 
                target:(id)object 
                selector:(SEL)selector;
- (void)unregisterHotKey:(void*)hotKeyRef;


-(NSNumber *)command;
-(NSNumber *)value;
-(void)setCommand:(NSNumber *)sender;
-(void)setValue:(NSNumber *)sender;

-(id)handleSendCommand:(NSScriptCommand *)command;
-(id)handleGetStatus:(NSScriptCommand *)s;
-(id)handleRecordTrigger:(NSScriptCommand *)s;

@end
