package jp.co.versus.adapter;

import java.util.ArrayList;
import java.util.List;

import android.content.Context;
import android.graphics.Color;
import android.text.TextUtils.TruncateAt;
import android.view.Gravity;
import android.view.View;
import android.view.ViewGroup;
import android.widget.BaseAdapter;
import android.widget.LinearLayout;
import android.widget.TextView;

public class PlayResultListAdapter extends BaseAdapter{
	private Context context;
	private List<PlayResultListItem> list;

	public PlayResultListAdapter(Context context){
		super();
		this.context = context;
		list = new ArrayList<PlayResultListItem>();
	}

	public void addItem(String team1, String team2, int point1, int point2, String resultId, String date){
		list.add(new PlayResultListItem(team1, team2, point1, point2, resultId, date));
		this.notifyDataSetChanged();
	}

	public void removeItem(int position){
		list.remove(position);
		this.notifyDataSetChanged();
	}

	public void removeAllItem(){
		list.clear();
		this.notifyDataSetChanged();
	}

	public void updateState(){
		this.notifyDataSetChanged();
	}

	@Override
	public int getCount() {
		return list.size();
	}

	@Override
	public Object getItem(int position) {
		return list.get(position);
	}

	@Override
	public long getItemId(int position) {
		return position;
	}

	@Override
	public View getView(int position, View convertView, ViewGroup parent) {
		PlayResultListItem item = (PlayResultListItem)getItem(position);
		LinearLayout layout = new LinearLayout(context);
		layout.setOrientation(LinearLayout.VERTICAL);
		convertView = layout;

		TextView tv = new TextView(context);
        tv.setTextSize(20);
        tv.setTextSize(25);
        tv.setPadding(0, 25, 0, 25);
        tv.setTextColor(Color.WHITE);
        tv.setHorizontallyScrolling(true);
        tv.setEllipsize(TruncateAt.END);
        tv.setGravity(Gravity.CENTER);
		tv.setText(item.getTeam1() + " VS " + item.getTeam2() + "\n" + item.getPoint1() + " VS " + item.getPoint2());
		layout.addView(tv);

		return convertView;
	}

	//リストアイテム
	public class PlayResultListItem{
		String mTeam1;
		String mTeam2;
		String mResultId;
		String mDate;
		int mPoint1;
		int mPoint2;

		public PlayResultListItem(String team1, String team2, int point1, int point2, String resultId, String date){
			this.mTeam1 = team1;
			this.mTeam2 = team2;
			this.mPoint1 = point1;
			this.mPoint2 = point2;
			this.mDate = date;
			this.mResultId = resultId;
		}

		public String getTeam1(){
			return mTeam1;
		}

		public void setTeam1(String team1){
			this.mTeam1 = team1;
		}

		public String getTeam2(){
			return mTeam2;
		}

		public void setTeam2(String team2){
			this.mTeam2 = team2;
		}

		public int getPoint1() {
			return mPoint1;
		}

		public void setPoint1(int point1) {
			this.mPoint1 = point1;
		}

		public int getPoint2() {
			return mPoint2;
		}

		public void setPoint2(int point2) {
			this.mPoint2 = point2;
		}

		public String getResultId() {
			return mResultId;
		}

		public void setResultId(String resultId) {
			this.mResultId = resultId;
		}

		public String getDate() {
			return mDate;
		}

		public void setDate(String date) {
			this.mDate = date;
		}
	}
}
