package jp.co.versus.adapter;

import java.util.ArrayList;
import java.util.List;

import android.content.Context;
import android.text.TextUtils.TruncateAt;
import android.view.View;
import android.view.ViewGroup;
import android.widget.BaseAdapter;
import android.widget.LinearLayout;
import android.widget.TextView;

public class PlayResultEditorListAdapter extends BaseAdapter{
	private Context context;
	private List<PlayResultEditorListItem> list;

	public PlayResultEditorListAdapter(Context context){
		super();
		this.context = context;
		list = new ArrayList<PlayResultEditorListItem>();
	}

	public void addItem(String scorer, String assist, String team, int color){
		list.add(new PlayResultEditorListItem(scorer, assist, team, color));
		this.notifyDataSetChanged();
	}

	public void removeItem(int position){
		list.remove(position);
		this.notifyDataSetChanged();
	}

	public void removeAllItem(){
		list.clear();
		this.notifyDataSetChanged();
	}

	public void updateState(){
		this.notifyDataSetChanged();
	}

	@Override
	public int getCount() {
		return list.size();
	}

	@Override
	public Object getItem(int position) {
		return list.get(position);
	}

	@Override
	public long getItemId(int position) {
		return position;
	}

	@Override
	public View getView(int position, View convertView, ViewGroup parent) {
		PlayResultEditorListItem item = (PlayResultEditorListItem)getItem(position);
		LinearLayout layout = new LinearLayout(context);
		layout.setOrientation(LinearLayout.VERTICAL);
		convertView = layout;

		TextView tv = new TextView(context);
		tv.setTextSize(25);
		tv.setPadding(0, 25, 0, 5);
		tv.setTextColor(item.color);
		tv.setHorizontallyScrolling(true);
		tv.setSingleLine(true);
		tv.setEllipsize(TruncateAt.END);
		tv.setText("得点者:" + item.getScorer());
		layout.addView(tv);

		TextView tv2 = new TextView(context);
		tv2.setTextSize(25);
		tv2.setPadding(0, 0, 0, 25);
		tv2.setTextColor(item.color);
		tv2.setHorizontallyScrolling(true);
		tv2.setSingleLine(true);
		tv2.setEllipsize(TruncateAt.END);
		tv2.setText("アシスト:" + item.getAssist());
		layout.addView(tv2);

		return convertView;
	}

	//リストアイテム
	public class PlayResultEditorListItem{
		String scorer;
		String assist;
		String team;
		int color;

		public PlayResultEditorListItem(String scorer, String assist, String team, int color){
			this.scorer = scorer;
			this.assist = assist;
			this.team = team;
			this.color = color;
			}

		public String getScorer(){
			return scorer;
		}

		public void setScorer(String scorer){
			this.scorer = scorer;
		}

		public String getAssist(){
			return assist;
		}

		public void setAssist(String assist){
			this.assist = assist;
		}

		public String getTeam(){
			return team;
		}

		public void setTeam(String team){
			this.team = team;
		}

	}

}
