package jp.co.versus.adapter;

import java.util.ArrayList;
import java.util.List;

import android.content.Context;
import android.graphics.Color;
import android.text.TextUtils.TruncateAt;
import android.view.View;
import android.view.ViewGroup;
import android.widget.BaseAdapter;
import android.widget.LinearLayout;
import android.widget.TextView;

public class PlayResultDateListAdapter extends BaseAdapter{
    private Context context;
    private List<PlayResultDateListItem> list;

    public PlayResultDateListAdapter(Context context){
        super();
        this.context = context;
        list = new ArrayList<PlayResultDateListItem>();
    }

    public void addItem(String date){
        list.add(new PlayResultDateListItem(date));
        this.notifyDataSetChanged();
    }

    public void addItem(String date, int position){
        list.add(position, new PlayResultDateListItem(date));
        this.notifyDataSetChanged();
    }

    public void removeItem(int position){
        list.remove(position);
        this.notifyDataSetChanged();
    }

    public void removeAllItem(){
        list.clear();
        this.notifyDataSetChanged();
    }

    @Override
    public int getCount() {
        return list.size();
    }

    @Override
    public Object getItem(int position) {
        return list.get(position);
    }

    @Override
    public long getItemId(int position) {
        return position;
    }

    @Override
    public View getView(int position, View convertView, ViewGroup parent) {
    	PlayResultDateListItem item = (PlayResultDateListItem)getItem(position);
        LinearLayout layout = new LinearLayout(context);
        layout.setOrientation(LinearLayout.VERTICAL);
        convertView = layout;

        TextView tv = new TextView(context);
        tv.setTextSize(20);
        tv.setTextSize(25);
        tv.setPadding(0, 25, 0, 25);
        tv.setTextColor(Color.WHITE);
        tv.setHorizontallyScrolling(true);
        tv.setSingleLine(true);
        tv.setEllipsize(TruncateAt.END);
        tv.setText(item.getDate());
        layout.addView(tv);

        return convertView;
    }

    //リストアイテム
    public class PlayResultDateListItem{
        String mDate;

        public PlayResultDateListItem(String date){
            this.mDate = date;
        }

        public String getDate(){
            return mDate;
        }
    }

}
