package jp.co.versus;

import jp.co.versus.R;
import jp.co.versus.adapter.PlayResultDateListAdapter;
import jp.co.versus.adapter.PlayResultDateListAdapter.PlayResultDateListItem;
import jp.co.versus.provider.VersusContract.Result;
import jp.co.versus.provider.VersusContract.Team;
import android.content.ContentResolver;
import android.content.Intent;
import android.database.Cursor;
import android.os.Bundle;
import android.support.v4.app.FragmentActivity;
import android.support.v4.app.LoaderManager.LoaderCallbacks;
import android.support.v4.content.CursorLoader;
import android.support.v4.content.Loader;
import android.util.Log;
import android.view.View;
import android.view.View.OnClickListener;
import android.widget.AdapterView;
import android.widget.Button;
import android.widget.ListView;
import android.widget.TextView;

public class VersusActivity extends FragmentActivity implements OnClickListener, LoaderCallbacks<Cursor>{
    private Button mPlayInfoEditorBtn;
    private Button mTeamEditorBtn;
    private Button mMemberEditorBtn;
    private PlayResultDateListAdapter mAdapter;
    private ListView mListView;
    private ContentResolver mContentResolver;
    final static public String KEY_DATE = "key.date";
    final static public int REQUEST_RESULT = 12;

    /** Called when the activity is first created. */
    @Override
    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.main);

        headerInitialize();

        mContentResolver = getContentResolver();
        getSupportLoaderManager().initLoader(0, null, this);
        mAdapter = new PlayResultDateListAdapter(getApplicationContext());
        mListView = (ListView) findViewById(R.id.listview);
        mListView.setAdapter(mAdapter);
        mListView.setOnItemClickListener(new AdapterView.OnItemClickListener() {

			@Override
			public void onItemClick(AdapterView<?> parent, View view, int position,
					long id) {
                ListView listView = (ListView)parent;
                long item = listView.getItemIdAtPosition(position);
                // 試合日を取得します。
				PlayResultDateListItem playResult = (PlayResultDateListItem)mAdapter.getItem((int)item);
				String getDate = playResult.getDate();
				Intent intent = new Intent(VersusActivity.this, ResultListActivity.class);
				intent.putExtra(KEY_DATE, getDate);
				startActivity(intent);
			}
		});

        mPlayInfoEditorBtn = (Button)findViewById(R.id.play_info_editor_btn);
        mTeamEditorBtn = (Button)findViewById(R.id.team_editor_btn);
        mMemberEditorBtn = (Button)findViewById(R.id.member_editor_btn);
		
		mPlayInfoEditorBtn.setOnClickListener(this);
		mTeamEditorBtn.setOnClickListener(this);
		mMemberEditorBtn.setOnClickListener(this);

    }

    @Override
    protected void onActivityResult(int requestCode, int resultCode, Intent intent){
        super.onActivityResult(requestCode, resultCode, intent);
        if(intent != null){
            Bundle bundle = intent.getExtras();
            switch(requestCode){
            case REQUEST_RESULT:
                if(bundle.getString(PlayResultEditorActivity.KEY_STRINGDATA).equals(PlayResultEditorActivity.RESULT_TRUE)){
                	mAdapter.removeAllItem();
                	getSupportLoaderManager().restartLoader(0, null, this);
                }
                break;
            }
        }
    }

    @Override
    public void onClick(View v) {
		switch(v.getId()){
		case R.id.play_info_editor_btn:
          Intent intentM = new Intent(VersusActivity.this, PlayInfoEditorActivity.class);
          startActivityForResult(intentM, REQUEST_RESULT);
          break;
		case R.id.team_editor_btn:
	          Intent intentN = new Intent(VersusActivity.this, TeamEditorActivity.class);
	          startActivity(intentN);
	          break;
		case R.id.member_editor_btn:
	          Intent intentL = new Intent(VersusActivity.this, MemberEditorActivity.class);
	          startActivity(intentL);
	          break;

        }
    }

    /**
     * ヘッダの初期化処理を行います。
     */
    private void headerInitialize() {
    	TextView headerText = (TextView)findViewById(R.id.header_title);
    	headerText.setText(R.string.header_main);
    }

	@Override
	public Loader<Cursor> onCreateLoader(int id, Bundle args) {
		return new CursorLoader(getApplicationContext(),
				Result.CONTENT_URI,
				new String[] {
			        Result._ID,
			        Result.DATE
			    },
			    null, null,
				Result.DATE + " asc");
	}

	@Override
	public void onLoadFinished(Loader<Cursor> loader, Cursor cursor) {
		if (cursor != null) {
			cursor.moveToFirst();
			do {
				try {
					String id = cursor.getString(0);
					String date = cursor.getString(1);
					int count = mAdapter.getCount(); 
					boolean isAdd = true;
					for (int i = 0; i < count; i++) {
						PlayResultDateListItem playResult = (PlayResultDateListItem)mAdapter.getItem(i);
						String getDate = playResult.getDate();
						// 同じ日付があるかチェックします。
						if (getDate.equals(date)) {
							isAdd = false;
							break;
						}
					}
					if (isAdd) {
						// 同じ日付がない場合のみ、リストに追加します。
						mAdapter.addItem(date);
					}
				} catch (Exception e) {
					Log.e("Test", e.getMessage());
					e.printStackTrace();
				}
			} while (cursor.moveToNext());
		}
	}

	@Override
	public void onLoaderReset(Loader<Cursor> cursor) {
	}
}