package jp.co.versus;

import jp.co.versus.R;
import jp.co.versus.provider.VersusContract.Team;
import android.content.Intent;
import android.database.Cursor;
import android.os.Bundle;
import android.support.v4.app.FragmentActivity;
import android.support.v4.app.LoaderManager.LoaderCallbacks;
import android.support.v4.content.CursorLoader;
import android.support.v4.content.Loader;
import android.util.Log;
import android.view.View;
import android.widget.AdapterView;
import android.widget.ArrayAdapter;
import android.widget.ListView;
import android.widget.TextView;

public class TeamSelectActivity extends FragmentActivity implements LoaderCallbacks<Cursor>{
    final static public String KEY_NUMBER = "key.number";
    final static public String KEY_EXCLUDE = "key.exclude";
    final static public String KEY_STRINGDATA = "key.Stringdata";

    private ArrayAdapter<String> mAdapter;
    private int team;
    private String excludeTeam;
    final static private String TAG = "TeamSelectActivity";

    @Override
    public void onCreate(Bundle savedInstanceState){
        super.onCreate(savedInstanceState);
        setContentView(R.layout.teamselect_layout);

        headerInitialize();

        Bundle bundle = getIntent().getExtras();
        if(bundle != null){
            team = bundle.getInt(KEY_NUMBER);
            excludeTeam = bundle.getString(KEY_EXCLUDE);
        }

    	mAdapter = new ArrayAdapter<String>(this, android.R.layout.simple_list_item_1);

        getSupportLoaderManager().initLoader(0, null, this);

        ListView listView = (ListView)findViewById(R.id.listview);
        listView.setAdapter(mAdapter);
        listView.setOnItemClickListener(new AdapterView.OnItemClickListener(){
            @Override
            public void onItemClick(AdapterView<?> parent, View view, int position,
                    long id) {
                ListView listView = (ListView)parent;
            	String data = (String)listView.getItemAtPosition(position);

                returnIntent(data);
                finish();
            }
        });
    }

    public void returnIntent(String teamName){
        Intent intent = new Intent();	//渡すインテント
        Bundle bundle = new Bundle();	//データ格納先
        bundle.putInt(KEY_NUMBER, team);
        bundle.putString(KEY_STRINGDATA, teamName);
        intent.putExtras(bundle);	//インテントにデータ格納
        setResult(RESULT_OK, intent);	//インテント完了通知
    }

    /**
     * ヘッダの初期化処理を行います。
     */
    private void headerInitialize() {
    	TextView headerText = (TextView)findViewById(R.id.header_title);
    	headerText.setText(R.string.header_team_select);
    }

	@Override
	public Loader<Cursor> onCreateLoader(int id, Bundle args) {
		return new CursorLoader(getApplicationContext(), Team.CONTENT_URI,
				new String[] {Team._ID, Team.TEAM }, Team.TEAM + "<>?",
				new String[]{excludeTeam}, Team.TEAM + " asc");
	}

	@Override
	public void onLoadFinished(Loader<Cursor> loader, Cursor cursor) {
		if (cursor != null) {
			cursor.moveToFirst();
			do {
				try {
					String id = cursor.getString(0);
					String team_name = cursor.getString(1);
					mAdapter.add(team_name);
					Log.d(TAG, "ID = " + id);
					Log.d(TAG, "Name = " + team_name);
				} catch (Exception e) {
				}
			} while (cursor.moveToNext());
		}
	}

	@Override
	public void onLoaderReset(Loader<Cursor> arg0) {
	}
}
