package jp.co.versus;

import jp.co.versus.R;
import jp.co.versus.R.color;
import jp.co.versus.adapter.PlayResultEditorListAdapter;
import jp.co.versus.adapter.PlayResultEditorListAdapter.PlayResultEditorListItem;
import jp.co.versus.provider.VersusContract.Point;
import jp.co.versus.provider.VersusContract.Result;
import jp.co.versus.provider.VersusContract.Team;
import android.app.Activity;
import android.content.ContentResolver;
import android.content.ContentValues;
import android.content.Intent;
import android.database.Cursor;
import android.graphics.Color;
import android.os.Bundle;
import android.text.ClipboardManager;
import android.view.ContextMenu;
import android.view.MenuItem;
import android.view.View;
import android.view.ContextMenu.ContextMenuInfo;
import android.view.MenuItem.OnMenuItemClickListener;
import android.view.View.OnClickListener;
import android.widget.Button;
import android.widget.ListAdapter;
import android.widget.ListView;
import android.widget.TextView;
import android.widget.AdapterView.AdapterContextMenuInfo;
import android.widget.Toast;

public class PlayResultEditorActivity extends Activity implements OnClickListener{
    final static public String KEY_STRINGDATA = "key.Stringdata";
    final static public String RESULT_TRUE = "true";
    final static public String RESULT_FALSE ="false";
    final static public String KEY_TEAM = "team name";
    final static public String POINT_UP = "point up";
    final static public String POINT_DOWN = "point down";
    final static public String DIALOG_EDIT = "編集";
    final static public String DIALOG_DELETE = "削除";

    //PlayPointに渡す用
    final static private int REQUEST_POINT = 147258;
    final static public String KEY_MODE = "key.mode";
    final static public String KEY_NAME1 = "key.name1";
    final static public String KEY_NAME2 = "key.name2";
    final static public String KEY_SCORE = "key.score";
    final static public String KEY_ITEM = "key.item";
    final static public String MODE_NEW = "mode.new";
    final static public String MODE_UP = "mode.up";

    private Button team1btn;
    private Button team2btn;
    private Button mCopyBtn;
    private TextView score1;
    private TextView score2;
    private ListView listView;
    private ListView mBeforeList;
    private int mResultId;
    private PlayResultEditorListAdapter adapter;
    private ContentResolver mContentResolver;
    private String mTeam1;
    private String mTeam2;
    private String mDate;
    private String mMode;

    @Override
    public void onCreate(Bundle savedInstanceState){
        super.onCreate(savedInstanceState);
        setContentView(R.layout.playresulteditor_layout);

        headerInitialize();

        adapter = new PlayResultEditorListAdapter(this);

        listView = (ListView)findViewById(R.id.listview);
        listView.setAdapter(adapter);
        registerForContextMenu(listView);

        team1btn = setButton(R.id.team1_btn);
        team2btn = setButton(R.id.team2_btn);
        mCopyBtn = setButton(R.id.copy_btn);
        setButton(R.id.ok_btn);
        setButton(R.id.cancel_btn);
        score1 = (TextView)findViewById(R.id.scoreinit_label1);
        score2 = (TextView)findViewById(R.id.scoreinit_label2);

        mContentResolver = getContentResolver();
        Intent intent = getIntent();
        Bundle bundle = intent.getExtras();

        if(bundle != null){	//渡ってきたデータがあればこっちに.食い込みないってことはないと思うけど
        	mTeam1 = bundle.getString(PlayInfoEditorActivity.TEAM1_KEY);
        	mTeam2 = bundle.getString(PlayInfoEditorActivity.TEAM2_KEY);
        	mDate = bundle.getString(PlayInfoEditorActivity.DATE_KEY);
        	mResultId = bundle.getInt(PlayInfoEditorActivity.RESULT_ID_KEY);
            setTitle(mDate);
            team1btn.setText(mTeam1);
            team2btn.setText(mTeam2);
            String resultId = bundle.getString(PlayInfoEditorActivity.RESULT_ID_KEY);
            mMode = bundle.getString(PlayInfoEditorActivity.MODE_KEY);
            int teamid_1 = 0;
            int teamid_2 = 0;
            Cursor cursor;
            cursor = mContentResolver.query(Team.CONTENT_URI, new String[]{
                    Team._ID}, Team.TEAM + "=?", new String[]{mTeam1}, null);
            if(cursor.moveToFirst()){	//チーム名に対するID取り出し
            	teamid_1 = cursor.getInt(0);
            }
            cursor.close();
            cursor = mContentResolver.query(Team.CONTENT_URI, new String[]{
                    Team._ID}, Team.TEAM + "=?", new String[]{mTeam2}, null);
            if(cursor.moveToFirst()){	//チーム名に対するID取り出し
            	teamid_2 = cursor.getInt(0);
            }
            cursor.close();
            if (mMode.equals(PlayInfoEditorActivity.MODE_EDIT)) {
	            cursor = mContentResolver.query(Point.CONTENT_URI, new String[]{
	                    Point.SCORER, Point.ASSIST}, Point.RESULTID + "=? and " + Point.TEAMID + "=?", new String[]{resultId, Integer.toString(teamid_1)}, null);
	            if (cursor.moveToFirst()) {
	            	do {
	            		String score = cursor.getString(0);
	            		String assist = cursor.getString(1);
                        adapter.addItem(score, assist, mTeam1, Color.RED);	//リストに赤でアイテム追加
                        point(POINT_UP, score1);	//赤1up
	            	} while (cursor.moveToNext());
	            }
	            cursor.close();
	            cursor = mContentResolver.query(Point.CONTENT_URI, new String[]{
	                    Point.SCORER, Point.ASSIST}, Point.RESULTID + "=? and " + Point.TEAMID + "=?", new String[]{resultId, Integer.toString(teamid_2)}, null);
	            if (cursor.moveToFirst()) {
	            	do {
	            		String score = cursor.getString(0);
	            		String assist = cursor.getString(1);
                        adapter.addItem(score, assist, mTeam2, getResources().getColor(color.blue2));	//リストに青でアイテム追加
                        point(POINT_UP, score2);	//青1up
	            	} while (cursor.moveToNext());
	            }
	            cursor.close();

	            mBeforeList = listView;
            }
        }
    }

    //コンテキストメニュー作成
    @Override
    public void onCreateContextMenu(ContextMenu menu, View v, ContextMenuInfo menuinfo){
        AdapterContextMenuInfo adapterMenuInfo = (AdapterContextMenuInfo) menuinfo;
        ListView listView = (ListView)v;
        final int position = adapterMenuInfo.position;
        final long id = listView.getItemIdAtPosition(position);
        menu.add(0, 0, 0, DIALOG_EDIT).setOnMenuItemClickListener(new OnMenuItemClickListener(){
            public boolean onMenuItemClick(MenuItem item) {	//編集時の動作
                PlayResultEditorListItem listItem = (PlayResultEditorListItem)adapter.getItem(position);
                sendIntent(MODE_UP, listItem.getScorer(), listItem.getAssist(), listItem.getTeam(), position);
                return false;
            }
        });
        menu.add(0, 1, 1, DIALOG_DELETE).setOnMenuItemClickListener(new OnMenuItemClickListener(){
            public boolean onMenuItemClick(MenuItem item) {	//削除時の動作
                PlayResultEditorListItem listItem = (PlayResultEditorListItem)adapter.getItem(position);
                if(team1btn.getText().toString().equals(listItem.getTeam())){
                    point(POINT_DOWN, score1);
                }else if(team2btn.getText().toString().equals(listItem.getTeam())){
                    point(POINT_DOWN, score2);
                }
                adapter.removeItem(position);
                return false;
            }
        });

    }

    @Override
    protected void onActivityResult(int requestCode, int resultCode, Intent intent){
        super.onActivityResult(requestCode, resultCode, intent);
        if(intent != null){
            Bundle bundle = intent.getExtras();
            switch(requestCode){
            case REQUEST_POINT:
                String mode = bundle.getString(KEY_MODE);
                if(mode.equals(MODE_NEW)){	//新規得点
                    if(bundle.getString(KEY_SCORE).equals(team1btn.getText().toString())){
                        adapter.addItem(bundle.getString(KEY_NAME1), bundle.getString(KEY_NAME2), bundle.getString(KEY_SCORE), Color.RED);	//リストに赤でアイテム追加
                        point(POINT_UP, score1);	//赤1up
                    }else if(bundle.getString(KEY_SCORE).equals(team2btn.getText().toString())){
                        adapter.addItem(bundle.getString(KEY_NAME1), bundle.getString(KEY_NAME2), bundle.getString(KEY_SCORE), getResources().getColor(color.blue2));	//青で
                        point(POINT_UP, score2);	//青1up
                    }
                }else if(mode.equals(MODE_UP)){//編集得点
                    PlayResultEditorListItem listItem = (PlayResultEditorListItem)adapter.getItem(bundle.getInt(KEY_ITEM));
                    listItem.setScorer(bundle.getString(KEY_NAME1));
                    listItem.setAssist(bundle.getString(KEY_NAME2));
                    adapter.updateState();
                }
                break;
            }
        }
    }

    //ボタン設定埋め込み
    public Button setButton(int id){
        Button button = (Button)findViewById(id);
        button.setOnClickListener(this);
        return button;
    }

    //得点View更新
    public void point(String mode, TextView score){
        int point = Integer.parseInt(score.getText().toString());
        if(mode.equals(POINT_UP)){
            point += 1;
        }else if(mode.equals(POINT_DOWN)){
            point -= 1;
        }
        score.setText(String.valueOf(point));
    }

    //起動用intent
    public void sendIntent(String mode, String scorer, String assist, String team, int itemId){
        Intent intent = new Intent(this, PlayPointEditorActivity.class);
        intent.putExtra(KEY_MODE, mode);
        intent.putExtra(KEY_NAME1, scorer);
        intent.putExtra(KEY_NAME2, assist);
        intent.putExtra(KEY_SCORE, team);
        intent.putExtra(KEY_ITEM, itemId);
        startActivityForResult(intent, REQUEST_POINT);
    }

    //返しintent生成
    public void returnIntent(String result){
        Intent intent = new Intent();	//渡すインテント
        Bundle bundle = new Bundle();	//データ格納先
        bundle.putString(KEY_STRINGDATA, result);
        intent.putExtras(bundle);	//インテントにデータ格納
        setResult(RESULT_OK, intent);	//インテント完了通知
    }

    @Override
    public void onClick(View v) {
        int id = v.getId();
        switch(id){
        case R.id.team1_btn:	//チーム1設定
            sendIntent(MODE_NEW, "", "", team1btn.getText().toString(), -1);
            break;
        case R.id.team2_btn:	//チーム2設定
            sendIntent(MODE_NEW, "", "", team2btn.getText().toString(), -1);
            break;
        case R.id.ok_btn:		//OKボタン
            //DBの登録ここでします。
        	if (mMode.equals(PlayInfoEditorActivity.MODE_EDIT)) {
        		deletePointDB();
            	insertPointDB();
        	} else {
            	insertPointDB();
            	insertResultDB(mDate, mTeam1, mTeam2);        		
        	}
            returnIntent(RESULT_TRUE);
            finish();
            break;
        case R.id.cancel_btn:	//キャンセルボタン
            returnIntent(RESULT_FALSE);
            finish();
            break;
        case R.id.copy_btn:     //コピーボタン
        	copyResult();
        	Toast toast = Toast.makeText
        			(getApplicationContext(), R.string.result_copy_complete, Toast.LENGTH_SHORT);
        	toast.show();
        	break;
        }
    }

    /**
     * 試合結果をクリップボードにコピーします。
     */
    private void copyResult() {
    	StringBuilder sb = new StringBuilder();
    	sb.append(mTeam1);
    	sb.append(" ");
    	sb.append(getText(R.string.vs_label));
    	sb.append(" ");
    	sb.append(mTeam2);
    	sb.append("\n");
    	sb.append(score1.getText());
    	sb.append(" ");
    	sb.append(getText(R.string.vs_label));
    	sb.append(" ");
    	sb.append(score2.getText());
    	sb.append("\n");
    	int num = listView.getCount();
    	for (int i = 0; i < num; i++) {
    		PlayResultEditorListItem listItem =
    				(PlayResultEditorListItem) listView.getItemAtPosition(i);
        	sb.append(getText(R.string.scorer_label));
        	sb.append(" : ");        	
        	sb.append(listItem.getScorer());
        	sb.append(" ");
        	sb.append(getText(R.string.assist_label));
        	sb.append(" : ");        	
        	sb.append(listItem.getAssist());
        	sb.append("\n");
    	}
    	 ClipboardManager cm = 
    		      (ClipboardManager) getSystemService(CLIPBOARD_SERVICE);
    	 cm.setText(sb.toString());
    }

    /**
     * 結果をDBに登録します。
     * 
     * @param date 試合日
     * @param team1 チーム1
     * @param team2 チーム2
     */
	private void insertResultDB(String date, String team1, String team2) {
		ContentValues cv = new ContentValues();
		cv.put(Result.DATE, date);
		cv.put(Result.TEAM1, team1);
		cv.put(Result.TEAM2, team2);
		cv.put(Result.RESULTID, Integer.toString(mResultId));
		mContentResolver.insert(Result.CONTENT_URI, cv);
	}

    private void insertPointDB() {
    	int num = listView.getCount();
    	for (int i =0; i < num; i++) {
    		PlayResultEditorListItem listItem = (PlayResultEditorListItem)adapter.getItem(i);
    		String assist = listItem.getAssist();
    		String score = listItem.getScorer();
    		String team = listItem.getTeam();
    		ContentValues cv = new ContentValues();
    		cv.put(Point.ASSIST, assist);
    		cv.put(Point.SCORER, score);
            int teamid = 0;	//チームID

            Cursor cursor = mContentResolver.query(Team.CONTENT_URI, new String[]{
                    Team._ID}, Team.TEAM + "=?", new String[]{team}, null);
            if(cursor.moveToFirst()){	//チーム名に対するID取り出し
            	teamid = cursor.getInt(0);
            	cursor.close();
        		cv.put(Point.TEAMID, teamid);
            }

            cv.put(Point.RESULTID, Integer.toString(mResultId));
    		mContentResolver.insert(Point.CONTENT_URI, cv);
    	}
    }

    private void deletePointDB() {
    	mContentResolver.delete(Point.CONTENT_URI, null, null);
    }

    /**
     * ヘッダの初期化処理を行います。
     */
    private void headerInitialize() {
    	TextView headerText = (TextView)findViewById(R.id.header_title);
    	headerText.setText(R.string.header_play_result);
    }
}
