package jp.co.versus;

import jp.co.versus.R;
import android.app.Activity;
import android.app.AlertDialog;
import android.content.DialogInterface;
import android.content.Intent;
import android.os.Bundle;
import android.view.View;
import android.view.View.OnClickListener;
import android.widget.Button;
import android.widget.TextView;
import android.widget.Toast;

public class PlayPointEditorActivity extends Activity implements OnClickListener{
    final static public int REQUEST_NAME = 159357;

    //PlayPointに渡す用
    final static public String KEY_MODE = "key.mode";
    final static public String KEY_NAME1 = "key.name1";
    final static public String KEY_NAME2 = "key.name2";
    final static public String KEY_SCORE = "key.score";
    final static public String KEY_ITEM = "key.item";
    final static public String MODE_NEW = "mode.new";
    final static public String MODE_UP = "mode.up";

    private Button scorerbtn;
    private Button assistbtn;
    private String mode;
    private String team;
    private int itemId = -1;

    @Override
    public void onCreate(Bundle savedInstanceState){
        super.onCreate(savedInstanceState);
        setContentView(R.layout.playpointeditor_layout);

        headerInitialize();

        scorerbtn = setButton(R.id.scorer_btn);
        assistbtn = setButton(R.id.assist_btn);
        setButton(R.id.ok_btn);
        setButton(R.id.cancel_btn);

        Bundle bundle = getIntent().getExtras();
        if(bundle != null){
            mode = bundle.getString(KEY_MODE);
            if(mode.equals(MODE_NEW)){
                team = bundle.getString(KEY_SCORE);	//スコアボードのID取得
            }else if(mode.equals(MODE_UP)){
                scorerbtn.setText(bundle.getString(KEY_NAME1));
                assistbtn.setText(bundle.getString(KEY_NAME2));
                team = bundle.getString(KEY_SCORE);
                itemId = bundle.getInt(KEY_ITEM);

            }
        }

    }

    @Override
    protected void onActivityResult(int requestCode, int resultCode, Intent intent){
        super.onActivityResult(requestCode, resultCode, intent);
        if(intent != null){
            Bundle bundle = intent.getExtras();
            switch(requestCode){
            case REQUEST_NAME:
            	if (resultCode == TeamMemberSelectActivity.RESULT_CANCELED) {
            		Toast.makeText(getApplicationContext(), "RESULT_CANCELED", Toast.LENGTH_SHORT).show();
            		return;
            	}
                String name = bundle.getString(TeamSelectActivity.KEY_STRINGDATA);
                if(bundle.getInt(TeamMemberSelectActivity.KEY_NUMBER) == R.id.scorer_btn){
                    scorerbtn.setText(name);
                }else if(bundle.getInt(TeamMemberSelectActivity.KEY_NUMBER) == R.id.assist_btn){
                    assistbtn.setText(name);
                }
                break;
            }
        }
    }

    //ボタン設定埋め込み
    public Button setButton(int id){
        Button button = (Button)findViewById(id);
        button.setOnClickListener(this);
        return button;
    }

    public void returnIntent(){
    	String score = scorerbtn.getText().toString();
    	String assist = assistbtn.getText().toString();
    	if (score.equals(getText(R.string.score).toString())) {
    		score = getText(R.string.player_unknown).toString();
    	}
    	if (assist.equals(getText(R.string.assist).toString())) {
    		assist = getText(R.string.player_unknown).toString();
    	}

        Intent intent = new Intent();	//渡すインテント
        intent.putExtra(KEY_MODE, mode);
        intent.putExtra(KEY_NAME1, score);
        intent.putExtra(KEY_NAME2, assist);
        intent.putExtra(KEY_SCORE, team);
        intent.putExtra(KEY_ITEM, itemId);
        setResult(RESULT_OK, intent);	//インテント完了通知
    }

    @Override
    public void onClick(View v) {
        int id = v.getId();
        Intent intent;
        switch(id){
        case R.id.scorer_btn:
            intent = new Intent(this, TeamMemberSelectActivity.class);
            intent.putExtra(TeamMemberSelectActivity.KEY_NUMBER, R.id.scorer_btn);
            intent.putExtra(TeamMemberSelectActivity.KEY_TEAM, team);
            intent.putExtra(TeamMemberSelectActivity.KEY_ACTIVITY_ID, TeamMemberSelectActivity.SCORE);
            startActivityForResult(intent, REQUEST_NAME);
            break;
        case R.id.assist_btn:
            intent = new Intent(this, TeamMemberSelectActivity.class);
            intent.putExtra(TeamMemberSelectActivity.KEY_NUMBER, R.id.assist_btn);
            intent.putExtra(TeamMemberSelectActivity.KEY_TEAM, team);
            intent.putExtra(TeamMemberSelectActivity.KEY_ACTIVITY_ID, TeamMemberSelectActivity.ASSIST);
            startActivityForResult(intent, REQUEST_NAME);
            break;
        case R.id.ok_btn:
            returnIntent();
            finish();
            break;
        case R.id.cancel_btn:
            finish();
            break;
        }
    }

    /**
     * ヘッダの初期化処理を行います。
     */
    private void headerInitialize() {
    	TextView headerText = (TextView)findViewById(R.id.header_title);
    	headerText.setText(R.string.header_play_point_edit);
    }

    private void showErrorDialog(String message) {
    	new AlertDialog.Builder(this)
		.setIcon(android.R.drawable.ic_dialog_info)
		.setMessage(message)
		.setPositiveButton("OK", new DialogInterface.OnClickListener() {
			public void onClick(DialogInterface dialog, int whichButton) {
			}
		}).show();
    }
}
