package jp.co.versus;

import jp.co.versus.R;
import jp.co.versus.provider.VersusContract.Member;
import android.content.Intent;
import android.database.Cursor;
import android.os.Bundle;
import android.support.v4.app.FragmentActivity;
import android.support.v4.app.LoaderManager.LoaderCallbacks;
import android.support.v4.content.CursorLoader;
import android.support.v4.content.Loader;
import android.util.Log;
import android.view.View;
import android.view.View.OnClickListener;
import android.widget.ArrayAdapter;
import android.widget.Button;
import android.widget.CheckedTextView;
import android.widget.ListView;
import android.widget.SimpleCursorAdapter;
import android.widget.TextView;

public class MemberSelectActivity extends FragmentActivity implements
        SimpleCursorAdapter.ViewBinder,OnClickListener, LoaderCallbacks<Cursor>{
    final static private String TAG = "MemberSelectActivity";
    final static public String KEY_STRINGDATA = "key.Stringdata";

    private ListView listView;
    private ArrayAdapter<String> mAdapter;

    @Override
    public void onCreate(Bundle savedInstanceState){
        super.onCreate(savedInstanceState);
        setContentView(R.layout.memberselect_layout);

        headerInitialize();

		getSupportLoaderManager().initLoader(0, null, this);

    	mAdapter = new ArrayAdapter<String>(this, android.R.layout.simple_list_item_multiple_choice);
    	
        listView = (ListView)findViewById(R.id.listview);
        listView.setAdapter(mAdapter);
        // フォーカスが当たらないよう設定
        listView.setItemsCanFocus(false);
        // 選択の方式の設定
        listView.setChoiceMode(ListView.CHOICE_MODE_MULTIPLE);
        registerForContextMenu(listView);

        setButton(R.id.ok_btn);
        setButton(R.id.cancel_btn);

    }

    //ボタン動作
    private void setButton(int id){
        Button button = (Button)findViewById(id);
        button.setOnClickListener(this);
    }

    //return intent　stringによる[,]区切りの数珠繋ぎ
    public void returnIntent(String data){
        Intent intent = new Intent();	//渡すインテント
        Bundle bundle = new Bundle();	//データ格納先
        bundle.putString(KEY_STRINGDATA, data);
        intent.putExtras(bundle);	//インテントにデータ格納
        setResult(RESULT_OK, intent);	//インテント完了通知
    }

    @Override
    public void onClick(View v) {
        int id = v.getId();
        switch(id){
        case R.id.ok_btn:
        	StringBuilder sb = new StringBuilder();
        	boolean isAdd = false;
        	for (int i = 0; i < listView.getChildCount(); i++) {
                CheckedTextView textView = (CheckedTextView)listView.getChildAt(i);
                if (textView.isChecked()) {
                	if (isAdd) {
                		sb.append(",");
                	}
                	String data = (String)listView.getItemAtPosition(i);
                	sb.append(data);
                	isAdd = true;
                	Log.d(TAG, "data = " + data);
                }
        	}

            returnIntent(sb.toString());
            finish();
            break;
        case R.id.cancel_btn:
            finish();
            break;
        }
    }

    @Override
    public boolean setViewValue(View view, Cursor cursor, int columnIndex) {
        // TODO 自動生成されたメソッド・スタブ
        return false;
    }

    /**
     * ヘッダの初期化処理を行います。
     */
    private void headerInitialize() {
    	TextView headerText = (TextView)findViewById(R.id.header_title);
    	headerText.setText(R.string.header_member_select);
    }

	@Override
	public Loader<Cursor> onCreateLoader(int arg0, Bundle arg1) {
		return new CursorLoader(getApplicationContext(), Member.CONTENT_URI,
				new String[] { Member._ID, Member.NAME }, null, null,
				Member.NAME + " asc");
	}

	@Override
	public void onLoadFinished(Loader<Cursor> loader, Cursor cursor) {
		if (cursor != null) {
			cursor.moveToFirst();
			do {
				try {
					String id = cursor.getString(0);
					String member_name = cursor.getString(1);
					mAdapter.add(member_name);
					Log.d(TAG, "ID = " + id);
					Log.d(TAG, "Name = " + member_name);
				} catch (Exception e) {
				}
			} while (cursor.moveToNext());
		}
	}

	@Override
	public void onLoaderReset(Loader<Cursor> arg0) {
	}
}
