#!/usr/bin/ruby
require 'sinatra/base'
require './vem'
require './hitachicontrol'
require './feicontrol'
require './jeolcontrol'
class Vemapi < Sinatra::Base
    @@controls = {
        "stagea"        => "setStageA",
        "stager"        => "setStager",
        "spotsize"      => "setSpotSize",
        "magnification" => "setMagnification",
        "obj"           => "setObj",
        "beamtilt"      => "setBeamTilt",
        "speed"         => "setSpeed"
    }
   
 get '/' do
         headers \
            "Access-Control-Allow-origin" => "*"
        'VEM API test'
    end

    get '/:emname/get' do
         headers \
            "Access-Control-Allow-origin" => "*"
        @@vem = VEM.create("#{params[:emname]}");
        result = @@vem.__send__("getCondition")
        "#{result}"
    end

    get '/:emname/set/:command' do
         headers \
            "Access-Control-Allow-origin" => "*"
        @@vem = VEM.create("#{params[:emname]}");
        command = "#{params[:command]}"
        result = @@vem.__send__(@@controls[command], params)
        "#{result}"
    end
end

 Vemapi.run! :host => 'localhost', :port =>  9090
