#ifndef _STDIO_H_VANE_
#define _STDIO_H_VANE_

extern unsigned short* screen;
extern char attr;
extern unsigned int X,Y;

void vga_text_init(void);
void vga_text_screen_clear_screen(void);
void vga_text_updata_cursor(void);

#define VGA_DEFAULT_ATTR    0x0F

#define VGA_ADDR 0xb8000

#define BRACK	0x00
#define BLUE	0x01
#define GREEN	0x02
#define CIAN	0x03
#define RED 	0x04
#define MASENTA	0x05
#define BRAWN	0x06
#define GLAY	0x07
#define D_GLAY	0x08
#define CH_BLUE	0x09
#define CH_GREE	0x0a
#define CH_CIAN	0x0b
#define PINK	0x0c
#define CH_MAS	0x0d
#define YELLOW	0x0e
#define WHITE	0x0f

#define CHAR_BYTE	1
#define SHORT_BYTE	2
#define INT_BYTE	4
#define LONG_BYTE	4
#define LONG_LONG_BYTE	8
#define DOUBLE_BYTE	8
#define FLOAT_BYTE	4

#define NULL	((void *) 0)

#define NUM_NULL 0
/*
#include <stdarg.h>

int sprintf(char *s, const char *format, ...);
int vsprintf(char *s, const char *format, va_list arg);
*/
char getchar(void);
char getch(void);

void ClearScreen(void);
void puts(const char* msg);
void putchar(const char);
void printOK(const char* msg);
int kbhit(void);
void printTASK(const char* msg);

#endif
