package jp.sourceforge.masasa.xlsXmlTemplate;

/**
 * ExcelXmlテンプレート定数クラス.
 *
 * @author masasa
 */
public final class ExcelXMLConstants {

    /**
     * シングルトン.
     */
    private ExcelXMLConstants() {
        // do nothing
    }

    /**
     * Activex.
     *
     * @author masasa
     */
    public static final class Activex {

        /**
         * シングルトン.
         */
        private Activex() {
            // do nothing
        }

        /** Excel.Application. */
        public static final String ACTIVEX_COMMAND_EXCEL_APPLICATION = "Excel.Application"; //$NON-NLS-1$
        /** Workbooks. */
        public static final String ACTIVEX_COMMAND_EXCEL_WORKBOOKS = "Workbooks"; //$NON-NLS-1$
    }

    /**
     * Dom.
     *
     * @author masasa
     */
    public static final class Dom {

        /**
         * シングルトン.
         */
        private Dom() {
            // do nothing
        }

        /** . */
        public static final String ALIGNMENT = "Alignment"; //$NON-NLS-1$
        /** . */
        public static final String CELL = "Cell"; //$NON-NLS-1$
        /** . */
        public static final String DATA = "Data"; //$NON-NLS-1$
        /** . */
        public static final String DATA_VALIDATION = "DataValidation"; //$NON-NLS-1$
        /** . */
        public static final String ERROR_HIDE = "ErrorHide"; //$NON-NLS-1$
        /** . */
        public static final String NAMED_RANGE = "NamedRange"; //$NON-NLS-1$
        /** . */
        public static final String NAMES = "Names"; //$NON-NLS-1$
        /** . */
        public static final String PANE = "Pane"; //$NON-NLS-1$
        /** . */
        public static final String PANES = "Panes"; //$NON-NLS-1$
        /** . */
        public static final String ROW = "Row"; //$NON-NLS-1$
        /** . */
        public static final String STRING = "String"; //$NON-NLS-1$
        /** . */
        public static final String NUMBER = "Number"; //$NON-NLS-1$
        /** . */
        public static final String TABLE = "Table"; //$NON-NLS-1$
        /** . */
        public static final String WORKSHEET = "Worksheet"; //$NON-NLS-1$
        /** . */
        public static final String WORKSHEET_OPTIONS = "WorksheetOptions"; //$NON-NLS-1$
        /** . */
        public static final String RANGE = "Range"; //$NON-NLS-1$
        /** . */
        public static final String VALUE = "Value"; //$NON-NLS-1$
        /** . */
        public static final String STYLE = "Style"; //$NON-NLS-1$
        /** . */
        public static final String STYLES = "Styles"; //$NON-NLS-1$
    }

    /**
     * Jacob.
     *
     * @author masasa
     */
    public static final class Jacob {

        /**
         * シングルトン.
         */
        private Jacob() {
            // do nothing
        }

        /** . */
        public static final String JACOB_COMMAND_CLOSE = "Close"; //$NON-NLS-1$
        /** . */
        public static final String JACOB_COMMAND_OPEN = "Open"; //$NON-NLS-1$
        /** . */
        public static final String JACOB_COMMAND_OPEN_XML = "OpenXML"; //$NON-NLS-1$

        /** . */
        public static final String JACOB_COMMAND_QUIT = "Quit"; //$NON-NLS-1$

        /** . */
        public static final String JACOB_COMMAND_SAVE_AS = "SaveAs"; //$NON-NLS-1$
    }

    /**
     * SpreadSheet.
     *
     * @author masasa
     */
    public static final class SpreadSheet {

        /**
         * シングルトン.
         */
        private SpreadSheet() {
            // do nothing
        }

        /** . */
        public static final String EXPANDED_ROW_COUNT = "ss:ExpandedRowCount"; //$NON-NLS-1$
        /** . */
        public static final String ID = "ss:ID"; //$NON-NLS-1$
        /** . */
        public static final String INDEX = "ss:Index"; //$NON-NLS-1$
        /** . */
        public static final String MERGE_ACROSS = "ss:MergeAcross"; //$NON-NLS-1$
        /** . */
        public static final String NAME = "ss:Name"; //$NON-NLS-1$
        /** . */
        public static final String REFERS_TO = "ss:RefersTo"; //$NON-NLS-1$
        /** . */
        public static final String STYLE_ID = "ss:StyleID"; //$NON-NLS-1$
        /** . */
        public static final String TYPE = "ss:Type"; //$NON-NLS-1$
        /** . */
        public static final String WRAP_TEXT = "ss:WrapText"; //$NON-NLS-1$
    }

    /**
     * Template.
     *
     * @author masasa
     */
    public static final class Template {

        /**
         * シングルトン.
         */
        private Template() {
            // do nothing
        }

        /** . */
        public static final String BEGIN = TEMPLATE_SEPARATOR.concat("Begin"); //$NON-NLS-1$
        /** . */
        public static final String END = TEMPLATE_SEPARATOR.concat("End"); //$NON-NLS-1$
        /** . */
        public static final String HLOOP = TEMPLATE_PLEFIX.concat("Hloop") //$NON-NLS-1$
                .concat(TEMPLATE_SEPARATOR);
        /** . */
        public static final String ITERATE = TEMPLATE_PLEFIX.concat("Iterate") //$NON-NLS-1$
                .concat(TEMPLATE_SEPARATOR);
        /** . */
        public static final String SHEET = TEMPLATE_PLEFIX.concat("Sheet") //$NON-NLS-1$
                .concat(TEMPLATE_SEPARATOR);
        /** . */
        public static final String VLOOP = TEMPLATE_PLEFIX.concat("Vloop") //$NON-NLS-1$
                .concat(TEMPLATE_SEPARATOR);

    }

    /** . */
    public static final String TEMPLATE_PLEFIX = "#"; //$NON-NLS-1$
    /** . */
    public static final String TEMPLATE_SEPARATOR = "."; //$NON-NLS-1$
    /** . */
    public static final String XML_ENCODE = "UTF-8"; //$NON-NLS-1$

}
