/**
 * \file audio_processing.c
 * \brief コーデックから受け取ったデータに対して、実際の信号処理を施す
 * \date 2011/02/19
 * \author: Takemasa Nakamura
 */

/**
 * \mainpage ADC Demo
 *
 * このアプリケーションでは、uzumeフレームワークの基本的な使い方として ADC操作関数 のデモンストレーションを行う。
 *
 * ユーザー・アルゴリズムは process_audio() 関数に実装しており、それ以外のコードは変更していない。
 * process_audio() 関数の中では、入力バッファから出力バッファへのコピーを行う際にADCからの読み取り値をかけている。
 * 乗算の後に15ビット左シフトしているのは、これが整数同士の乗算ではなく、固定小数点数の積だからである。
 *
 */


#include "arm_math.h"
#include "uzume.h"
	/** \brief 左チャンネルインデックス */
#define LCH 0
	/** \brief 右チャンネルインデックス */
#define RCH 1

void init_audio( void )
{
	/*
	 * 必要に応じてここに初期化プログラムを書いておく。
	 */
}

void process_audio( const AUDIO_SAMPLE input[2][UZUME_BLOCK_SIZE], AUDIO_SAMPLE output[2][UZUME_BLOCK_SIZE] )
{
	int i;

		/*
		 * 入力データはinput[][]に格納されている。input[LCH][]が、左チャンネル、
		 * input[RCH][]が右チャンネルである。それぞれのチャンネルにはUZUME_BLOCK_SIZE個の
		 * データが格納されている。各データは2の補数符号付き左詰め形式の整数
		 * （つまり1.15形式固定小数点数）である。
		 *
		 * 出力データの形式も同じである。
		 */
	for ( i = 0; i< UZUME_BLOCK_SIZE; i++ )
	{
			/*
			 *  入出力にVR1,2の値を適用する。adc0がVR1である。
			 *  Kirishima実装では、ADC_SAMPLEもAUDIO_SAMPLEも16ビット符号付き整数である。
			 *  このような実装では、かけ算を行った後に15ビット右にシフトすることでオーバーフローを
			 *  避けることができる。
			 */
		output[LCH][i] = input[LCH][i] * adc_read(0) >> 15;
		output[RCH][i] = input[RCH][i] * adc_read(1) >> 15;
	}
}
