/**
 * @file cmd.h
 * @author Shinichiro Nakamura
 * @brief コマンドの定義。
 * @details
 */

#ifndef CMD_H
#define CMD_H

#include "ntshell.h"
#include "ntstdio.h"

/**
 * @brief コマンド環境構造体からシェルモジュールハンドラを取得する。
 * @parma ENV コマンド環境構造体。
 * @return シェルモジュールハンドラ。
 */
#define CMD_NTSHELL(ENV)    (&((ENV)->ntshell))

/**
 * @brief コマンド環境構造体から標準入出力モジュールハンドラを取得する。
 * @parma ENV コマンド環境構造体。
 * @return 標準入出力モジュールハンドラ。
 */
#define CMD_NTSTDIO(ENV)    (&((ENV)->ntstdio))

/**
 * @brief コマンド環境構造体。
 */
typedef struct {
    ntshell_t ntshell;  /**< シェルモジュールハンドラ */
    ntstdio_t ntstdio;  /**< 標準入出力モジュールハンドラ */
} cmd_env_t;

/**
 * @brief コマンド関数。
 * @details
 * ntshell_taskを使用するBSPは、cmd_executeの実装を提供する。
 * VT100のシーケンスコード解釈や環境設定は上位で行われている。
 *
 * @param env コマンド環境構造体。
 * @param argc パラメータ数。
 * @param argv パラメータ。
 */
void cmd_execute(cmd_env_t *env, int argc, char **argv);

#endif

