/**
 * @file i2s_subsystem.h
 * @author takemasa
 * @brief I2Sコーデックの初期化及び管理
 */

#ifndef I2S_SUBSYSTEM_H_
#define I2S_SUBSYSTEM_H_

#include <t_services.h>
#include <s_services.h>
#include "uzume.h"

/*
* CODEC_TASKのタスク優先順位。0が最も優先順位が高い。I2SのCODEC制御はDMA割り込みに連動する。基本的には小ディレイは
* 問題なく、割り込み周期いないで処理が完結すればいい。GUIよりも優先順位を高く、プロトコル・スタックのような応答性能が
* 求められるタスクより低く設定する。
*
* 変更する場合には sys_config.h でマクロ宣言する
*/
#ifndef CODEC_TASK_PRI
#define CODEC_TASK_PRI 3
#endif

#ifndef CODEC_TASK_STACK_SIZE
#define CODEC_TASK_STACK_SIZE 1024
#endif

/**
 * @brief サンプルあたりのスロット数。I2Sなら2。
 */
#define SLOT_PER_SAMPLE 2



/**
 * @brief CODECとデータをやり取りするためのバッファ
 * @details
 * 割り込み１回の間にCODECが転送するデータを格納するバッファ。サイズは
 * 割り込み１回あたりのサンプル数 @ref UZUME_BLOCKSIZE と1サンプル内の
 * スロット数 @ref SLOT_PER_SAMPLE の積である。
 */
struct CODEC_BUFFER{
    AUDIOSAMPLE data[UZUME_BLOCKSIZE][SLOT_PER_SAMPLE];
} ;

/*
 *  関数のプロトタイプ宣言
 */
#ifndef _MACRO_ONLY


extern void task_audiocodec( VP_INT exinf );
extern void inh_codec_sport(void);
extern void init_audio( void );
extern void init_codec();
extern void process_audio(
        AUDIOSAMPLE input_left[],
        AUDIOSAMPLE input_right[],
        AUDIOSAMPLE output_left[],
        AUDIOSAMPLE output_right[]
        );

#endif /* _MACRO_ONLY */


#endif /* I2S_SUBSYSTEM_H_ */
