/**
 * @file cmd_amakusa592.c
 * @author Shinichiro Nakamura
 * @brief amakusa592コマンドの実装。
 * @details
 */

#include "cmd.h"

/**
 * @brief コマンド関数。
 * @details
 * ntshell_taskを使用するBSPは、cmd_executeの実装を提供する。
 * VT100のシーケンスコード解釈や環境設定は上位で行われている。
 *
 * @param env コマンド環境構造体。
 * @param argc パラメータ数。
 * @param argv パラメータ。
 */
void cmd_execute(cmd_env_t *env, int argc, char **argv)
{
    int i;
    for (i = 0; i < argc; i++) {
        ntstdio_printf(CMD_NTSTDIO(env), "%d : '%s'\n", i, argv[i]);
    }
}

