/**
 * @file display_task.c
 * @author Shinichiro Nakamura
 * @brief
 * @details
 */

#include <t_services.h>
#include "display_task.h"
#include "kernel_id.h"
#include "lcd.h"

#define DEBUG   (1)

static void cmd_clear(display_clear_t *p)
{
    lcd_clear();
}

void display_task(VP_INT exinf)
{
    display_msg_t *msg;

    syslog(LOG_NOTICE, "Display Task");

    lcd_init();
    lcd_clear();
    lcd_puts(">");

    while(1) {
#if DEBUG
        if (rcv_mbx(MBX_DISPLAY, (T_MSG**)&msg) == E_OK) {
            switch (msg->cmd) {
                case DISPLAY_CMD_CLEAR:
                    cmd_clear(&(msg->arg.clear));
                    break;
                default:
                    break;
            }
            rel_mpf(MPF_DISPLAY, (VP)msg);
        }
#else
        tslp_tsk(200);
        static int c = 'A';
        lcd_putc(c);
        c = (c == 'Z') ? 'A' : (c + 1);
#endif
    }
}

void display_clear(void)
{
#if DEBUG
    VP vp;
    if (get_mpf(MPF_DISPLAY, &vp) == E_OK) {
        display_msg_t *msg = (display_msg_t *)vp;
        msg->cmd = DISPLAY_CMD_CLEAR;
        msg->arg.clear.dummy = 0;
        snd_mbx(MBX_DISPLAY, vp);
    }
#else
#endif
}

