/*
 * ADSP-BF592の System MMR 定義。アドレスの指定は .ldファイルとの組み合わせで行う。
 *
 * アドレスが正しく割り当てられているかは、次の方法で検証した.
 *
 $ cat /opt/uClinux/bfin-elf/bfin-elf/include/def_LPBlackfin.h /opt/uClinux/bfin-elf/bfin-elf/include/defBF59x_base.h /opt/uClinux/bfin-elf/bfin-elf/include/defBF592-A.h | tr '[a-z]' '[A-Z]' | grep '0XFF[CE]0' | grep "#DEFINE" | awk '{print $2, $3}' - | grep 0X  | sed 's/0X//' |  sort -k 2 > regdef.txt
 $ bfin-elf-readelf -s -W mmr_bf592.out | grep OBJ | awk '{print $8,$2}'| grep _mmr | sed 's/_mmr//p' | sort -k 2 | uniq | tr '[a-z]' '[A-Z]' > regelf.txt
 $ diff regelf.txt regdef.txt > diff.txt

334a335
> DCPLB_FAULT_STATUS FFE00008
372d372
< IMEM_DUMMY FFE01000
373a374
> CODE_FAULT_STATUS FFE01008
374a376
> CODE_FAULT_ADDR FFE0100C
427d428
< IDUMMY FFE02100
437d437
< DBGDUMMY FFE05004


 * いずれも小さな問題であり、したがって、上の結果は問題ないと言える。
 *
 */





volatile unsigned short  mmrPLL_CTL __attribute ((aligned(4), section("SYSMMR0")));
volatile unsigned short  mmrPLL_DIV __attribute ((aligned(4), section("SYSMMR0")));
volatile unsigned short  mmrVR_CTL __attribute ((aligned(4), section("SYSMMR0")));
volatile unsigned short  mmrPLL_STAT __attribute ((aligned(4), section("SYSMMR0")));
volatile unsigned short  mmrPLL_LOCKCNT __attribute ((aligned(4), section("SYSMMR0")));
volatile unsigned long   mmrCHIPID __attribute ((aligned(4), section("SYSMMR0")));
volatile unsigned short  mmrSWRST __attribute ((aligned(4), section("SYSMMR1")));
volatile unsigned short  mmrSYSCR __attribute ((aligned(4), section("SYSMMR1")));
volatile unsigned long   mmrSIC_IMASK0 __attribute ((aligned(4), section("SYSMMR2")));
volatile unsigned long   mmrSIC_IAR0 __attribute ((aligned(4), section("SYSMMR2")));
volatile unsigned long   mmrSIC_IAR1 __attribute ((aligned(4), section("SYSMMR2")));
volatile unsigned long   mmrSIC_IAR2 __attribute ((aligned(4), section("SYSMMR2")));
volatile unsigned long   mmrSIC_IAR3 __attribute ((aligned(4), section("SYSMMR2")));
volatile unsigned long   mmrSIC_ISR0 __attribute ((aligned(4), section("SYSMMR2")));
volatile unsigned long   mmrSIC_IWR0 __attribute ((aligned(4), section("SYSMMR2")));
volatile unsigned short  mmrWDOG_CTL __attribute ((aligned(4), section("SYSMMR4")));
volatile unsigned long   mmrWDOG_CNT __attribute ((aligned(4), section("SYSMMR4")));
volatile unsigned long   mmrWDOG_STAT __attribute ((aligned(4), section("SYSMMR4")));
volatile unsigned short  mmrUART0_THR __attribute ((aligned(4), section("SYSMMR6")));
volatile unsigned short  mmrUART0_IER __attribute ((aligned(4), section("SYSMMR6")));
volatile unsigned short  mmrUART0_IIR __attribute ((aligned(4), section("SYSMMR6")));
volatile unsigned short  mmrUART0_LCR __attribute ((aligned(4), section("SYSMMR6")));
volatile unsigned short  mmrUART0_MCR __attribute ((aligned(4), section("SYSMMR6")));
volatile unsigned short  mmrUART0_LSR __attribute ((aligned(4), section("SYSMMR6")));
volatile unsigned short  mmrUART0_SCR __attribute ((aligned(4), section("SYSMMR7")));
volatile unsigned short  mmrUART0_GCTL __attribute ((aligned(4), section("SYSMMR8")));
volatile unsigned short  mmrSPI0_CTL __attribute ((aligned(4), section("SYSMMR9")));
volatile unsigned short  mmrSPI0_FLG __attribute ((aligned(4), section("SYSMMR9")));
volatile unsigned short  mmrSPI0_STAT __attribute ((aligned(4), section("SYSMMR9")));
volatile unsigned short  mmrSPI0_TDBR __attribute ((aligned(4), section("SYSMMR9")));
volatile unsigned short  mmrSPI0_RDBR __attribute ((aligned(4), section("SYSMMR9")));
volatile unsigned short  mmrSPI0_BAUD __attribute ((aligned(4), section("SYSMMR9")));
volatile unsigned short  mmrSPI0_SHADOW __attribute ((aligned(4), section("SYSMMR9")));
volatile unsigned short  mmrTIMER0_CONFIG __attribute ((aligned(4), section("SYSMMR10")));
volatile unsigned long   mmrTIMER0_COUNTER __attribute ((aligned(4), section("SYSMMR10")));
volatile unsigned long   mmrTIMER0_PERIOD __attribute ((aligned(4), section("SYSMMR10")));
volatile unsigned long   mmrTIMER0_WIDTH __attribute ((aligned(4), section("SYSMMR10")));
volatile unsigned short  mmrTIMER1_CONFIG __attribute ((aligned(4), section("SYSMMR10")));
volatile unsigned long   mmrTIMER1_COUNTER __attribute ((aligned(4), section("SYSMMR10")));
volatile unsigned long   mmrTIMER1_PERIOD __attribute ((aligned(4), section("SYSMMR10")));
volatile unsigned long   mmrTIMER1_WIDTH __attribute ((aligned(4), section("SYSMMR10")));
volatile unsigned short  mmrTIMER2_CONFIG __attribute ((aligned(4), section("SYSMMR10")));
volatile unsigned long   mmrTIMER2_COUNTER __attribute ((aligned(4), section("SYSMMR10")));
volatile unsigned long   mmrTIMER2_PERIOD __attribute ((aligned(4), section("SYSMMR10")));
volatile unsigned long   mmrTIMER2_WIDTH __attribute ((aligned(4), section("SYSMMR10")));
volatile unsigned short  mmrTIMER_ENABLE __attribute ((aligned(4), section("SYSMMR105")));
volatile unsigned short  mmrTIMER_DISABLE __attribute ((aligned(4), section("SYSMMR105")));
volatile unsigned long   mmrTIMER_STATUS __attribute ((aligned(4), section("SYSMMR105")));
volatile unsigned short  mmrPORTFIO __attribute ((aligned(4), section("SYSMMR11")));
volatile unsigned short  mmrPORTFIO_CLEAR __attribute ((aligned(4), section("SYSMMR11")));
volatile unsigned short  mmrPORTFIO_SET __attribute ((aligned(4), section("SYSMMR11")));
volatile unsigned short  mmrPORTFIO_TOGGLE __attribute ((aligned(4), section("SYSMMR11")));
volatile unsigned short  mmrPORTFIO_MASKA __attribute ((aligned(4), section("SYSMMR11")));
volatile unsigned short  mmrPORTFIO_MASKA_CLEAR __attribute ((aligned(4), section("SYSMMR11")));
volatile unsigned short  mmrPORTFIO_MASKA_SET __attribute ((aligned(4), section("SYSMMR11")));
volatile unsigned short  mmrPORTFIO_MASKA_TOGGLE __attribute ((aligned(4), section("SYSMMR11")));
volatile unsigned short  mmrPORTFIO_MASKB __attribute ((aligned(4), section("SYSMMR11")));
volatile unsigned short  mmrPORTFIO_MASKB_CLEAR __attribute ((aligned(4), section("SYSMMR11")));
volatile unsigned short  mmrPORTFIO_MASKB_SET __attribute ((aligned(4), section("SYSMMR11")));
volatile unsigned short  mmrPORTFIO_MASKB_TOGGLE __attribute ((aligned(4), section("SYSMMR11")));
volatile unsigned short  mmrPORTFIO_DIR __attribute ((aligned(4), section("SYSMMR11")));
volatile unsigned short  mmrPORTFIO_POLAR __attribute ((aligned(4), section("SYSMMR11")));
volatile unsigned short  mmrPORTFIO_EDGE __attribute ((aligned(4), section("SYSMMR11")));
volatile unsigned short  mmrPORTFIO_BOTH __attribute ((aligned(4), section("SYSMMR11")));
volatile unsigned short  mmrPORTFIO_INEN __attribute ((aligned(4), section("SYSMMR11")));
volatile unsigned short  mmrSPORT0_TCR1 __attribute ((aligned(4), section("SYSMMR12")));
volatile unsigned short  mmrSPORT0_TCR2 __attribute ((aligned(4), section("SYSMMR12")));
volatile unsigned short  mmrSPORT0_TCLKDIV __attribute ((aligned(4), section("SYSMMR12")));
volatile unsigned short  mmrSPORT0_TFSDIV __attribute ((aligned(4), section("SYSMMR12")));
volatile unsigned long   mmrSPORT0_TX __attribute ((aligned(4), section("SYSMMR12")));
volatile unsigned long   mmrSPORT0_RX __attribute ((aligned(4), section("SYSMMR13")));
volatile unsigned short  mmrSPORT0_RCR1 __attribute ((aligned(4), section("SYSMMR14")));
volatile unsigned short  mmrSPORT0_RCR2 __attribute ((aligned(4), section("SYSMMR14")));
volatile unsigned short  mmrSPORT0_RCLKDIV __attribute ((aligned(4), section("SYSMMR14")));
volatile unsigned short  mmrSPORT0_RFSDIV __attribute ((aligned(4), section("SYSMMR14")));
volatile unsigned short  mmrSPORT0_STAT __attribute ((aligned(4), section("SYSMMR14")));
volatile unsigned short  mmrSPORT0_CHNL __attribute ((aligned(4), section("SYSMMR14")));
volatile unsigned short  mmrSPORT0_MCMC1 __attribute ((aligned(4), section("SYSMMR14")));
volatile unsigned short  mmrSPORT0_MCMC2 __attribute ((aligned(4), section("SYSMMR14")));
volatile unsigned long   mmrSPORT0_MTCS0 __attribute ((aligned(4), section("SYSMMR14")));
volatile unsigned long   mmrSPORT0_MTCS1 __attribute ((aligned(4), section("SYSMMR14")));
volatile unsigned long   mmrSPORT0_MTCS2 __attribute ((aligned(4), section("SYSMMR14")));
volatile unsigned long   mmrSPORT0_MTCS3 __attribute ((aligned(4), section("SYSMMR14")));
volatile unsigned long   mmrSPORT0_MRCS0 __attribute ((aligned(4), section("SYSMMR14")));
volatile unsigned long   mmrSPORT0_MRCS1 __attribute ((aligned(4), section("SYSMMR14")));
volatile unsigned long   mmrSPORT0_MRCS2 __attribute ((aligned(4), section("SYSMMR14")));
volatile unsigned long   mmrSPORT0_MRCS3 __attribute ((aligned(4), section("SYSMMR14")));
volatile unsigned short  mmrSPORT1_TCR1 __attribute ((aligned(4), section("SYSMMR15")));
volatile unsigned short  mmrSPORT1_TCR2 __attribute ((aligned(4), section("SYSMMR15")));
volatile unsigned short  mmrSPORT1_TCLKDIV __attribute ((aligned(4), section("SYSMMR15")));
volatile unsigned short  mmrSPORT1_TFSDIV __attribute ((aligned(4), section("SYSMMR15")));
volatile unsigned long   mmrSPORT1_TX __attribute ((aligned(4), section("SYSMMR15")));
volatile unsigned long   mmrSPORT1_RX __attribute ((aligned(4), section("SYSMMR16")));
volatile unsigned short  mmrSPORT1_RCR1 __attribute ((aligned(4), section("SYSMMR17")));
volatile unsigned short  mmrSPORT1_RCR2 __attribute ((aligned(4), section("SYSMMR17")));
volatile unsigned short  mmrSPORT1_RCLKDIV __attribute ((aligned(4), section("SYSMMR17")));
volatile unsigned short  mmrSPORT1_RFSDIV __attribute ((aligned(4), section("SYSMMR17")));
volatile unsigned short  mmrSPORT1_STAT __attribute ((aligned(4), section("SYSMMR17")));
volatile unsigned short  mmrSPORT1_CHNL __attribute ((aligned(4), section("SYSMMR17")));
volatile unsigned short  mmrSPORT1_MCMC1 __attribute ((aligned(4), section("SYSMMR17")));
volatile unsigned short  mmrSPORT1_MCMC2 __attribute ((aligned(4), section("SYSMMR17")));
volatile unsigned long   mmrSPORT1_MTCS0 __attribute ((aligned(4), section("SYSMMR17")));
volatile unsigned long   mmrSPORT1_MTCS1 __attribute ((aligned(4), section("SYSMMR17")));
volatile unsigned long   mmrSPORT1_MTCS2 __attribute ((aligned(4), section("SYSMMR17")));
volatile unsigned long   mmrSPORT1_MTCS3 __attribute ((aligned(4), section("SYSMMR17")));
volatile unsigned long   mmrSPORT1_MRCS0 __attribute ((aligned(4), section("SYSMMR17")));
volatile unsigned long   mmrSPORT1_MRCS1 __attribute ((aligned(4), section("SYSMMR17")));
volatile unsigned long   mmrSPORT1_MRCS2 __attribute ((aligned(4), section("SYSMMR17")));
volatile unsigned long   mmrSPORT1_MRCS3 __attribute ((aligned(4), section("SYSMMR17")));

volatile unsigned short  mmrDMA_TC_PER __attribute ((aligned(4), section("SYSMMR20")));
volatile unsigned short  mmrDMA_TC_CNT __attribute ((aligned(4), section("SYSMMR20")));
volatile unsigned long   mmrDMA0_NEXT_DESC_PTR __attribute ((aligned(4), section("SYSMMR21")));
volatile unsigned long   mmrDMA0_START_ADDR __attribute ((aligned(4), section("SYSMMR21")));
volatile unsigned short  mmrDMA0_CONFIG __attribute ((aligned(4), section("SYSMMR21")));
volatile unsigned short  mmrDMA0_X_COUNT __attribute ((aligned(4), section("SYSMMR22")));
volatile signed   short  mmrDMA0_X_MODIFY __attribute ((aligned(4), section("SYSMMR22")));
volatile unsigned short  mmrDMA0_Y_COUNT __attribute ((aligned(4), section("SYSMMR22")));
volatile signed   short  mmrDMA0_Y_MODIFY __attribute ((aligned(4), section("SYSMMR22")));
volatile unsigned long   mmrDMA0_CURR_DESC_PTR __attribute ((aligned(4), section("SYSMMR22")));
volatile unsigned long   mmrDMA0_CURR_ADDR __attribute ((aligned(4), section("SYSMMR22")));
volatile unsigned short  mmrDMA0_IRQ_STATUS __attribute ((aligned(4), section("SYSMMR22")));
volatile unsigned short  mmrDMA0_PERIPHERAL_MAP __attribute ((aligned(4), section("SYSMMR22")));
volatile unsigned short  mmrDMA0_CURR_X_COUNT __attribute ((aligned(4), section("SYSMMR22")));
volatile unsigned short  mmrDMA0_CURR_Y_COUNT __attribute ((aligned(4), section("SYSMMR23")));
volatile unsigned long   mmrDMA1_NEXT_DESC_PTR __attribute ((aligned(4), section("SYSMMR24")));
volatile unsigned long   mmrDMA1_START_ADDR __attribute ((aligned(4), section("SYSMMR24")));
volatile unsigned short  mmrDMA1_CONFIG __attribute ((aligned(4), section("SYSMMR24")));
volatile unsigned short  mmrDMA1_X_COUNT __attribute ((aligned(4), section("SYSMMR25")));
volatile signed   short  mmrDMA1_X_MODIFY __attribute ((aligned(4), section("SYSMMR25")));
volatile unsigned short  mmrDMA1_Y_COUNT __attribute ((aligned(4), section("SYSMMR25")));
volatile signed   short  mmrDMA1_Y_MODIFY __attribute ((aligned(4), section("SYSMMR25")));
volatile unsigned long   mmrDMA1_CURR_DESC_PTR __attribute ((aligned(4), section("SYSMMR25")));
volatile unsigned long   mmrDMA1_CURR_ADDR __attribute ((aligned(4), section("SYSMMR25")));
volatile unsigned short  mmrDMA1_IRQ_STATUS __attribute ((aligned(4), section("SYSMMR25")));
volatile unsigned short  mmrDMA1_PERIPHERAL_MAP __attribute ((aligned(4), section("SYSMMR25")));
volatile unsigned short  mmrDMA1_CURR_X_COUNT __attribute ((aligned(4), section("SYSMMR25")));
volatile unsigned short  mmrDMA1_CURR_Y_COUNT __attribute ((aligned(4), section("SYSMMR26")));
volatile unsigned long   mmrDMA2_NEXT_DESC_PTR __attribute ((aligned(4), section("SYSMMR27")));
volatile unsigned long   mmrDMA2_START_ADDR __attribute ((aligned(4), section("SYSMMR27")));
volatile unsigned short  mmrDMA2_CONFIG __attribute ((aligned(4), section("SYSMMR27")));
volatile unsigned short  mmrDMA2_X_COUNT __attribute ((aligned(4), section("SYSMMR28")));
volatile signed   short  mmrDMA2_X_MODIFY __attribute ((aligned(4), section("SYSMMR28")));
volatile unsigned short  mmrDMA2_Y_COUNT __attribute ((aligned(4), section("SYSMMR28")));
volatile signed   short  mmrDMA2_Y_MODIFY __attribute ((aligned(4), section("SYSMMR28")));
volatile unsigned long   mmrDMA2_CURR_DESC_PTR __attribute ((aligned(4), section("SYSMMR28")));
volatile unsigned long   mmrDMA2_CURR_ADDR __attribute ((aligned(4), section("SYSMMR28")));
volatile unsigned short  mmrDMA2_IRQ_STATUS __attribute ((aligned(4), section("SYSMMR28")));
volatile unsigned short  mmrDMA2_PERIPHERAL_MAP __attribute ((aligned(4), section("SYSMMR28")));
volatile unsigned short  mmrDMA2_CURR_X_COUNT __attribute ((aligned(4), section("SYSMMR28")));
volatile unsigned short  mmrDMA2_CURR_Y_COUNT __attribute ((aligned(4), section("SYSMMR29")));
volatile unsigned long   mmrDMA3_NEXT_DESC_PTR __attribute ((aligned(4), section("SYSMMR30")));
volatile unsigned long   mmrDMA3_START_ADDR __attribute ((aligned(4), section("SYSMMR30")));
volatile unsigned short  mmrDMA3_CONFIG __attribute ((aligned(4), section("SYSMMR30")));
volatile unsigned short  mmrDMA3_X_COUNT __attribute ((aligned(4), section("SYSMMR31")));
volatile signed   short  mmrDMA3_X_MODIFY __attribute ((aligned(4), section("SYSMMR31")));
volatile unsigned short  mmrDMA3_Y_COUNT __attribute ((aligned(4), section("SYSMMR31")));
volatile signed   short  mmrDMA3_Y_MODIFY __attribute ((aligned(4), section("SYSMMR31")));
volatile unsigned long   mmrDMA3_CURR_DESC_PTR __attribute ((aligned(4), section("SYSMMR31")));
volatile unsigned long   mmrDMA3_CURR_ADDR __attribute ((aligned(4), section("SYSMMR31")));
volatile unsigned short  mmrDMA3_IRQ_STATUS __attribute ((aligned(4), section("SYSMMR31")));
volatile unsigned short  mmrDMA3_PERIPHERAL_MAP __attribute ((aligned(4), section("SYSMMR31")));
volatile unsigned short  mmrDMA3_CURR_X_COUNT __attribute ((aligned(4), section("SYSMMR31")));
volatile unsigned short  mmrDMA3_CURR_Y_COUNT __attribute ((aligned(4), section("SYSMMR32")));
volatile unsigned long   mmrDMA4_NEXT_DESC_PTR __attribute ((aligned(4), section("SYSMMR33")));
volatile unsigned long   mmrDMA4_START_ADDR __attribute ((aligned(4), section("SYSMMR33")));
volatile unsigned short  mmrDMA4_CONFIG __attribute ((aligned(4), section("SYSMMR33")));
volatile unsigned short  mmrDMA4_X_COUNT __attribute ((aligned(4), section("SYSMMR34")));
volatile signed   short  mmrDMA4_X_MODIFY __attribute ((aligned(4), section("SYSMMR34")));
volatile unsigned short  mmrDMA4_Y_COUNT __attribute ((aligned(4), section("SYSMMR34")));
volatile signed   short  mmrDMA4_Y_MODIFY __attribute ((aligned(4), section("SYSMMR34")));
volatile unsigned long   mmrDMA4_CURR_DESC_PTR __attribute ((aligned(4), section("SYSMMR34")));
volatile unsigned long   mmrDMA4_CURR_ADDR __attribute ((aligned(4), section("SYSMMR34")));
volatile unsigned short  mmrDMA4_IRQ_STATUS __attribute ((aligned(4), section("SYSMMR34")));
volatile unsigned short  mmrDMA4_PERIPHERAL_MAP __attribute ((aligned(4), section("SYSMMR34")));
volatile unsigned short  mmrDMA4_CURR_X_COUNT __attribute ((aligned(4), section("SYSMMR34")));
volatile unsigned short  mmrDMA4_CURR_Y_COUNT __attribute ((aligned(4), section("SYSMMR35")));
volatile unsigned long   mmrDMA5_NEXT_DESC_PTR __attribute ((aligned(4), section("SYSMMR36")));
volatile unsigned long   mmrDMA5_START_ADDR __attribute ((aligned(4), section("SYSMMR36")));
volatile unsigned short  mmrDMA5_CONFIG __attribute ((aligned(4), section("SYSMMR36")));
volatile unsigned short  mmrDMA5_X_COUNT __attribute ((aligned(4), section("SYSMMR37")));
volatile signed   short  mmrDMA5_X_MODIFY __attribute ((aligned(4), section("SYSMMR37")));
volatile unsigned short  mmrDMA5_Y_COUNT __attribute ((aligned(4), section("SYSMMR37")));
volatile signed   short  mmrDMA5_Y_MODIFY __attribute ((aligned(4), section("SYSMMR37")));
volatile unsigned long   mmrDMA5_CURR_DESC_PTR __attribute ((aligned(4), section("SYSMMR37")));
volatile unsigned long   mmrDMA5_CURR_ADDR __attribute ((aligned(4), section("SYSMMR37")));
volatile unsigned short  mmrDMA5_IRQ_STATUS __attribute ((aligned(4), section("SYSMMR37")));
volatile unsigned short  mmrDMA5_PERIPHERAL_MAP __attribute ((aligned(4), section("SYSMMR37")));
volatile unsigned short  mmrDMA5_CURR_X_COUNT __attribute ((aligned(4), section("SYSMMR37")));
volatile unsigned short  mmrDMA5_CURR_Y_COUNT __attribute ((aligned(4), section("SYSMMR38")));
volatile unsigned long   mmrDMA6_NEXT_DESC_PTR __attribute ((aligned(4), section("SYSMMR39")));
volatile unsigned long   mmrDMA6_START_ADDR __attribute ((aligned(4), section("SYSMMR39")));
volatile unsigned short  mmrDMA6_CONFIG __attribute ((aligned(4), section("SYSMMR39")));
volatile unsigned short  mmrDMA6_X_COUNT __attribute ((aligned(4), section("SYSMMR40")));
volatile signed   short  mmrDMA6_X_MODIFY __attribute ((aligned(4), section("SYSMMR40")));
volatile unsigned short  mmrDMA6_Y_COUNT __attribute ((aligned(4), section("SYSMMR40")));
volatile signed   short  mmrDMA6_Y_MODIFY __attribute ((aligned(4), section("SYSMMR40")));
volatile unsigned long   mmrDMA6_CURR_DESC_PTR __attribute ((aligned(4), section("SYSMMR40")));
volatile unsigned long   mmrDMA6_CURR_ADDR __attribute ((aligned(4), section("SYSMMR40")));
volatile unsigned short  mmrDMA6_IRQ_STATUS __attribute ((aligned(4), section("SYSMMR40")));
volatile unsigned short  mmrDMA6_PERIPHERAL_MAP __attribute ((aligned(4), section("SYSMMR40")));
volatile unsigned short  mmrDMA6_CURR_X_COUNT __attribute ((aligned(4), section("SYSMMR40")));
volatile unsigned short  mmrDMA6_CURR_Y_COUNT __attribute ((aligned(4), section("SYSMMR41")));
volatile unsigned long   mmrDMA7_NEXT_DESC_PTR __attribute ((aligned(4), section("SYSMMR42")));
volatile unsigned long   mmrDMA7_START_ADDR __attribute ((aligned(4), section("SYSMMR42")));
volatile unsigned short  mmrDMA7_CONFIG __attribute ((aligned(4), section("SYSMMR42")));
volatile unsigned short  mmrDMA7_X_COUNT __attribute ((aligned(4), section("SYSMMR43")));
volatile signed   short  mmrDMA7_X_MODIFY __attribute ((aligned(4), section("SYSMMR43")));
volatile unsigned short  mmrDMA7_Y_COUNT __attribute ((aligned(4), section("SYSMMR43")));
volatile signed   short  mmrDMA7_Y_MODIFY __attribute ((aligned(4), section("SYSMMR43")));
volatile unsigned long   mmrDMA7_CURR_DESC_PTR __attribute ((aligned(4), section("SYSMMR43")));
volatile unsigned long   mmrDMA7_CURR_ADDR __attribute ((aligned(4), section("SYSMMR43")));
volatile unsigned short  mmrDMA7_IRQ_STATUS __attribute ((aligned(4), section("SYSMMR43")));
volatile unsigned short  mmrDMA7_PERIPHERAL_MAP __attribute ((aligned(4), section("SYSMMR43")));
volatile unsigned short  mmrDMA7_CURR_X_COUNT __attribute ((aligned(4), section("SYSMMR43")));
volatile unsigned short  mmrDMA7_CURR_Y_COUNT __attribute ((aligned(4), section("SYSMMR44")));
volatile unsigned long   mmrDMA8_NEXT_DESC_PTR __attribute ((aligned(4), section("SYSMMR45")));
volatile unsigned long   mmrDMA8_START_ADDR __attribute ((aligned(4), section("SYSMMR45")));
volatile unsigned short  mmrDMA8_CONFIG __attribute ((aligned(4), section("SYSMMR45")));
volatile unsigned short  mmrDMA8_X_COUNT __attribute ((aligned(4), section("SYSMMR46")));
volatile signed   short  mmrDMA8_X_MODIFY __attribute ((aligned(4), section("SYSMMR46")));
volatile unsigned short  mmrDMA8_Y_COUNT __attribute ((aligned(4), section("SYSMMR46")));
volatile signed   short  mmrDMA8_Y_MODIFY __attribute ((aligned(4), section("SYSMMR46")));
volatile unsigned long   mmrDMA8_CURR_DESC_PTR __attribute ((aligned(4), section("SYSMMR46")));
volatile unsigned long   mmrDMA8_CURR_ADDR __attribute ((aligned(4), section("SYSMMR46")));
volatile unsigned short  mmrDMA8_IRQ_STATUS __attribute ((aligned(4), section("SYSMMR46")));
volatile unsigned short  mmrDMA8_PERIPHERAL_MAP __attribute ((aligned(4), section("SYSMMR46")));
volatile unsigned short  mmrDMA8_CURR_X_COUNT __attribute ((aligned(4), section("SYSMMR46")));
volatile unsigned short  mmrDMA8_CURR_Y_COUNT __attribute ((aligned(4), section("SYSMMR47")));


volatile unsigned long   mmrMDMA_D0_NEXT_DESC_PTR __attribute ((aligned(4), section("SYSMMR57")));
volatile unsigned long   mmrMDMA_D0_START_ADDR __attribute ((aligned(4), section("SYSMMR57")));
volatile unsigned short  mmrMDMA_D0_CONFIG __attribute ((aligned(4), section("SYSMMR57")));
volatile unsigned short  mmrMDMA_D0_X_COUNT __attribute ((aligned(4), section("SYSMMR58")));
volatile signed   short  mmrMDMA_D0_X_MODIFY __attribute ((aligned(4), section("SYSMMR58")));
volatile unsigned short  mmrMDMA_D0_Y_COUNT __attribute ((aligned(4), section("SYSMMR58")));
volatile signed   short  mmrMDMA_D0_Y_MODIFY __attribute ((aligned(4), section("SYSMMR58")));
volatile unsigned long   mmrMDMA_D0_CURR_DESC_PTR __attribute ((aligned(4), section("SYSMMR58")));
volatile unsigned long   mmrMDMA_D0_CURR_ADDR __attribute ((aligned(4), section("SYSMMR58")));
volatile unsigned short  mmrMDMA_D0_IRQ_STATUS __attribute ((aligned(4), section("SYSMMR58")));
volatile unsigned short  mmrMDMA_D0_PERIPHERAL_MAP __attribute ((aligned(4), section("SYSMMR58")));
volatile unsigned short  mmrMDMA_D0_CURR_X_COUNT __attribute ((aligned(4), section("SYSMMR58")));
volatile unsigned short  mmrMDMA_D0_CURR_Y_COUNT __attribute ((aligned(4), section("SYSMMR59")));
volatile unsigned long   mmrMDMA_S0_NEXT_DESC_PTR __attribute ((aligned(4), section("SYSMMR60")));
volatile unsigned long   mmrMDMA_S0_START_ADDR __attribute ((aligned(4), section("SYSMMR60")));
volatile unsigned short  mmrMDMA_S0_CONFIG __attribute ((aligned(4), section("SYSMMR60")));
volatile unsigned short  mmrMDMA_S0_X_COUNT __attribute ((aligned(4), section("SYSMMR61")));
volatile signed   short  mmrMDMA_S0_X_MODIFY __attribute ((aligned(4), section("SYSMMR61")));
volatile unsigned short  mmrMDMA_S0_Y_COUNT __attribute ((aligned(4), section("SYSMMR61")));
volatile signed   short  mmrMDMA_S0_Y_MODIFY __attribute ((aligned(4), section("SYSMMR61")));
volatile unsigned long   mmrMDMA_S0_CURR_DESC_PTR __attribute ((aligned(4), section("SYSMMR61")));
volatile unsigned long   mmrMDMA_S0_CURR_ADDR __attribute ((aligned(4), section("SYSMMR61")));
volatile unsigned short  mmrMDMA_S0_IRQ_STATUS __attribute ((aligned(4), section("SYSMMR61")));
volatile unsigned short  mmrMDMA_S0_PERIPHERAL_MAP __attribute ((aligned(4), section("SYSMMR61")));
volatile unsigned short  mmrMDMA_S0_CURR_X_COUNT __attribute ((aligned(4), section("SYSMMR61")));
volatile unsigned short  mmrMDMA_S0_CURR_Y_COUNT __attribute ((aligned(4), section("SYSMMR62")));
volatile unsigned long   mmrMDMA_D1_NEXT_DESC_PTR __attribute ((aligned(4), section("SYSMMR63")));
volatile unsigned long   mmrMDMA_D1_START_ADDR __attribute ((aligned(4), section("SYSMMR63")));
volatile unsigned short  mmrMDMA_D1_CONFIG __attribute ((aligned(4), section("SYSMMR63")));
volatile unsigned short  mmrMDMA_D1_X_COUNT __attribute ((aligned(4), section("SYSMMR64")));
volatile signed   short  mmrMDMA_D1_X_MODIFY __attribute ((aligned(4), section("SYSMMR64")));
volatile unsigned short  mmrMDMA_D1_Y_COUNT __attribute ((aligned(4), section("SYSMMR64")));
volatile signed   short  mmrMDMA_D1_Y_MODIFY __attribute ((aligned(4), section("SYSMMR64")));
volatile unsigned long   mmrMDMA_D1_CURR_DESC_PTR __attribute ((aligned(4), section("SYSMMR64")));
volatile unsigned long   mmrMDMA_D1_CURR_ADDR __attribute ((aligned(4), section("SYSMMR64")));
volatile unsigned short  mmrMDMA_D1_IRQ_STATUS __attribute ((aligned(4), section("SYSMMR64")));
volatile unsigned short  mmrMDMA_D1_PERIPHERAL_MAP __attribute ((aligned(4), section("SYSMMR64")));
volatile unsigned short  mmrMDMA_D1_CURR_X_COUNT __attribute ((aligned(4), section("SYSMMR64")));
volatile unsigned short  mmrMDMA_D1_CURR_Y_COUNT __attribute ((aligned(4), section("SYSMMR65")));
volatile unsigned long   mmrMDMA_S1_NEXT_DESC_PTR __attribute ((aligned(4), section("SYSMMR66")));
volatile unsigned long   mmrMDMA_S1_START_ADDR __attribute ((aligned(4), section("SYSMMR66")));
volatile unsigned short  mmrMDMA_S1_CONFIG __attribute ((aligned(4), section("SYSMMR66")));
volatile unsigned short  mmrMDMA_S1_X_COUNT __attribute ((aligned(4), section("SYSMMR67")));
volatile signed   short  mmrMDMA_S1_X_MODIFY __attribute ((aligned(4), section("SYSMMR67")));
volatile unsigned short  mmrMDMA_S1_Y_COUNT __attribute ((aligned(4), section("SYSMMR67")));
volatile signed   short  mmrMDMA_S1_Y_MODIFY __attribute ((aligned(4), section("SYSMMR67")));
volatile unsigned long   mmrMDMA_S1_CURR_DESC_PTR __attribute ((aligned(4), section("SYSMMR67")));
volatile unsigned long   mmrMDMA_S1_CURR_ADDR __attribute ((aligned(4), section("SYSMMR67")));
volatile unsigned short  mmrMDMA_S1_IRQ_STATUS __attribute ((aligned(4), section("SYSMMR67")));
volatile unsigned short  mmrMDMA_S1_PERIPHERAL_MAP __attribute ((aligned(4), section("SYSMMR67")));
volatile unsigned short  mmrMDMA_S1_CURR_X_COUNT __attribute ((aligned(4), section("SYSMMR67")));
volatile unsigned short  mmrMDMA_S1_CURR_Y_COUNT __attribute ((aligned(4), section("SYSMMR68")));

volatile unsigned short  mmrPPI_CONTROL __attribute ((aligned(4), section("SYSMMR69")));
volatile unsigned short  mmrPPI_STATUS __attribute ((aligned(4), section("SYSMMR69")));
volatile unsigned short  mmrPPI_COUNT __attribute ((aligned(4), section("SYSMMR69")));
volatile unsigned short  mmrPPI_DELAY __attribute ((aligned(4), section("SYSMMR69")));
volatile unsigned short  mmrPPI_FRAME __attribute ((aligned(4), section("SYSMMR69")));

volatile unsigned short  mmrTWI_CLKDIV __attribute ((aligned(4), section("SYSMMR70")));
volatile unsigned short  mmrTWI_CONTROL __attribute ((aligned(4), section("SYSMMR70")));
volatile unsigned short  mmrTWI_SLAVE_CTL __attribute ((aligned(4), section("SYSMMR70")));
volatile unsigned short  mmrTWI_SLAVE_STAT __attribute ((aligned(4), section("SYSMMR70")));
volatile unsigned short  mmrTWI_SLAVE_ADDR __attribute ((aligned(4), section("SYSMMR70")));
volatile unsigned short  mmrTWI_MASTER_CTL __attribute ((aligned(4), section("SYSMMR70")));
volatile unsigned short  mmrTWI_MASTER_STAT __attribute ((aligned(4), section("SYSMMR70")));
volatile unsigned short  mmrTWI_MASTER_ADDR __attribute ((aligned(4), section("SYSMMR70")));
volatile unsigned short  mmrTWI_INT_STAT __attribute ((aligned(4), section("SYSMMR70")));
volatile unsigned short  mmrTWI_INT_MASK __attribute ((aligned(4), section("SYSMMR70")));
volatile unsigned short  mmrTWI_FIFO_CTL __attribute ((aligned(4), section("SYSMMR70")));
volatile unsigned short  mmrTWI_FIFO_STAT __attribute ((aligned(4), section("SYSMMR70")));
volatile unsigned short  mmrTWI_XMT_DATA8 __attribute ((aligned(4), section("SYSMMR71")));
volatile unsigned short  mmrTWI_XMT_DATA16 __attribute ((aligned(4), section("SYSMMR71")));
volatile unsigned short  mmrTWI_RCV_DATA8 __attribute ((aligned(4), section("SYSMMR71")));
volatile unsigned short  mmrTWI_RCV_DATA16 __attribute ((aligned(4), section("SYSMMR71")));

volatile unsigned short  mmrPORTGIO __attribute ((aligned(4), section("SYSMMR72")));
volatile unsigned short  mmrPORTGIO_CLEAR __attribute ((aligned(4), section("SYSMMR72")));
volatile unsigned short  mmrPORTGIO_SET __attribute ((aligned(4), section("SYSMMR72")));
volatile unsigned short  mmrPORTGIO_TOGGLE __attribute ((aligned(4), section("SYSMMR72")));
volatile unsigned short  mmrPORTGIO_MASKA __attribute ((aligned(4), section("SYSMMR72")));
volatile unsigned short  mmrPORTGIO_MASKA_CLEAR __attribute ((aligned(4), section("SYSMMR72")));
volatile unsigned short  mmrPORTGIO_MASKA_SET __attribute ((aligned(4), section("SYSMMR72")));
volatile unsigned short  mmrPORTGIO_MASKA_TOGGLE __attribute ((aligned(4), section("SYSMMR72")));
volatile unsigned short  mmrPORTGIO_MASKB __attribute ((aligned(4), section("SYSMMR72")));
volatile unsigned short  mmrPORTGIO_MASKB_CLEAR __attribute ((aligned(4), section("SYSMMR72")));
volatile unsigned short  mmrPORTGIO_MASKB_SET __attribute ((aligned(4), section("SYSMMR72")));
volatile unsigned short  mmrPORTGIO_MASKB_TOGGLE __attribute ((aligned(4), section("SYSMMR72")));
volatile unsigned short  mmrPORTGIO_DIR __attribute ((aligned(4), section("SYSMMR72")));
volatile unsigned short  mmrPORTGIO_POLAR __attribute ((aligned(4), section("SYSMMR72")));
volatile unsigned short  mmrPORTGIO_EDGE __attribute ((aligned(4), section("SYSMMR72")));
volatile unsigned short  mmrPORTGIO_BOTH __attribute ((aligned(4), section("SYSMMR72")));
volatile unsigned short  mmrPORTGIO_INEN __attribute ((aligned(4), section("SYSMMR72")));

volatile unsigned short  mmrPORTF_FER __attribute ((aligned(4), section("SYSMMR83")));
volatile unsigned short  mmrPORTF_MUX __attribute ((aligned(4), section("SYSMMR83")));
volatile unsigned short  mmrPORTF_PADCTL __attribute ((aligned(4), section("SYSMMR83")));
volatile unsigned short  mmrPORTG_FER __attribute ((aligned(4), section("SYSMMR84")));
volatile unsigned short  mmrPORTG_MUX __attribute ((aligned(4), section("SYSMMR84")));
volatile unsigned short  mmrPORTG_PADCTL __attribute ((aligned(4), section("SYSMMR84")));
volatile unsigned short  mmrSPORT_GATECLK __attribute ((aligned(4), section("SYSMMR84")));

volatile unsigned short  mmrSPI1_CTL __attribute ((aligned(4), section("SYSMMR91")));
volatile unsigned short  mmrSPI1_FLG __attribute ((aligned(4), section("SYSMMR91")));
volatile unsigned short  mmrSPI1_STAT __attribute ((aligned(4), section("SYSMMR91")));
volatile unsigned short  mmrSPI1_TDBR __attribute ((aligned(4), section("SYSMMR91")));
volatile unsigned short  mmrSPI1_RDBR __attribute ((aligned(4), section("SYSMMR91")));
volatile unsigned short  mmrSPI1_BAUD __attribute ((aligned(4), section("SYSMMR91")));
volatile unsigned short  mmrSPI1_SHADOW __attribute ((aligned(4), section("SYSMMR91")));

