/**
 * @file uzume.h
 * @brief CODEC関連定義
 */
#ifndef UZUME_H_
#define UZUME_H_

#include <s_services.h>
#include <t_services.h>
#include <fract_math.h>
/**
 * @brief オーディオコーデック用データ型。
 * @details
 * Blackfinでは32bitで使用する。整数部のビット長は、 UZUME_INT_BITS で宣言する。
 */
typedef fract32 AUDIOSAMPLE;

/**
 * @brief 割り込み1回あたりのサンプル数。ユーザーが変えてもよい。
 * @details
 * 変更したい場合は、sys_config.hで宣言すると良い。
 */
#ifndef UZUME_INT_BITS
#define UZUME_INT_BITS 0
#endif

/**
 * @brief スケーリング・ファクター
 * @details
 * AUDIOSAMPLE型の整数部のビット数を指定する。0の場合フォーマットは1.32、
 * 3ならば4.28、7ならば8.24となる。デフォルトで64だが、変更したければsys_config.hで宣言すると良い。
 */
#ifndef UZUME_BLOCKSIZE
#define UZUME_BLOCKSIZE 64
#endif

#ifndef _MACRO_ONLY

extern fract32 get_volume(unsigned int ch);
extern void set_volume(unsigned int ch, fract32 value);

#endif

#endif /*UZUME_H_*/
